<?php
/* Copyright (C) 2001-2005 Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2015 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@inodbox.com>
 * Copyright (C) 2015      Jean-François Ferry	<jfefe@aternatik.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file       htdocs/fichajes/template/fichajesindex.php
 *	\ingroup    fichajes
 *	\brief      Home page of fichajes top menu
 */

// Load Dolibarr environment
$res=0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (! $res && ! empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) $res=@include $_SERVER["CONTEXT_DOCUMENT_ROOT"]."/main.inc.php";
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp=empty($_SERVER['SCRIPT_FILENAME'])?'':$_SERVER['SCRIPT_FILENAME'];$tmp2=realpath(__FILE__); $i=strlen($tmp)-1; $j=strlen($tmp2)-1;
while($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i]==$tmp2[$j]) { $i--; $j--; }
if (! $res && $i > 0 && file_exists(substr($tmp, 0, ($i+1))."/main.inc.php")) $res=@include substr($tmp, 0, ($i+1))."/main.inc.php";
if (! $res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i+1)))."/main.inc.php")) $res=@include dirname(substr($tmp, 0, ($i+1)))."/main.inc.php";
// Try main.inc.php using relative path
if (! $res && file_exists("../main.inc.php")) $res=@include "../main.inc.php";
if (! $res && file_exists("../../main.inc.php")) $res=@include "../../main.inc.php";
if (! $res && file_exists("../../../main.inc.php")) $res=@include "../../../main.inc.php";
if (! $res) die("Include of main fails");

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';

// Load translation files required by the page
$langs->loadLangs(array("fichajes@fichajes"));

$action=GETPOST('action', 'alpha');

// Securite acces client
if (! $user->rights->fichajes->read) accessforbidden();
$socid=GETPOST('socid','int');
if (isset($user->societe_id) && $user->societe_id > 0)
{
	$action = '';
	$socid = $user->societe_id;
}

$max=5;
$now=dol_now();


/*
 * Actions
 */

if ($action == "ficharentrada") {
	$sql = "INSERT INTO " . MAIN_DB_PREFIX . "fichajes_log (user_id, tms, mov_type, description, geoposition) VALUES (" . $user->id . ", '".date("Y-m-d H:i:s")."', 'Entrada', '', '')";
	$resql= $db->query($sql);
} elseif ($action == "ficharsalida") {
	$sql = "INSERT INTO " . MAIN_DB_PREFIX . "fichajes_log (user_id, tms, mov_type, description, geoposition) VALUES (" . $user->id . ", '".date("Y-m-d H:i:s")."', 'Salida', '', '')";
	$resql= $db->query($sql);
} elseif ($action == "ficharpausa_confirmar") {
	$description = GETPOST('description', 'alpha');
	$sql = "INSERT INTO " . MAIN_DB_PREFIX . "fichajes_log (user_id, tms, mov_type, description, geoposition) VALUES (" . $user->id . ", '".date("Y-m-d H:i:s")."', 'Pausa', '".$description."', '')";
	$resql= $db->query($sql);
}


/*
 * View
 */

$form = new Form($db);
$formfile = new FormFile($db);

llxHeader("",$langs->trans("Fichajes"));

print load_fiche_titre($langs->trans("Fichajes"),'','fichajes.png@fichajes');

if ($action == 'ficharpausa') {
	$formquestion=array(
		'description'=>array('type'=>'text','label'=>'Descripción de la pausa', 'value'=>'','name'=>'description')
	);

	$formconfirm = $form->formconfirm($_SERVER["PHP_SELF"] . '?id=' . $object->id, 'Pausa', '', 'ficharpausa_confirmar', $formquestion, 0, 1);
	print $formconfirm;
}

print '<div class="fichecenter"><div class="fichethirdleft">';


print '<form name="ficharentrada" style="display: inline" action="' . $_SERVER["PHP_SELF"] . '" method="POST">' . "\n";
print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
print '<input type="hidden" name="action" value="ficharentrada">';

print '<input class="butAction" style="text-decoration: none;
text-transform: uppercase;
font-weight: bold;
margin: 0em 0.9em !important;
padding: 0.6em 0.7em;
font-family: roboto, arial, tahoma, verdana, helvetica;
display: inline-block;
text-align: center;
cursor: pointer;
color: rgb(51,102,0);
background: rgb(217, 228,207);" type="submit" value="Entrada">';
print '</form>';

print '<form name="ficharsalida" style="display: inline"  action="' . $_SERVER["PHP_SELF"] . '" method="POST">' . "\n";
print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
print '<input type="hidden" name="action" value="ficharsalida">';

print '<input class="butAction butActionRed" style="text-decoration: none;
text-transform: uppercase;
font-weight: bold;
margin: 0em 0.9em !important;
padding: 0.6em 0.7em;
font-family: roboto, arial, tahoma, verdana, helvetica;
display: inline-block;
text-align: center;
cursor: pointer;
color: rgb(102,0,0);
background: rgb(255, 204,204);" type="submit" value="Salida">';
print '</form>';

print '<form name="ficharpausa" style="display: inline"  action="' . $_SERVER["PHP_SELF"] . '" method="POST">' . "\n";
print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
print '<input type="hidden" name="action" value="ficharpausa">';

print '<input class="butAction" style="text-decoration: none;
text-transform: uppercase;
font-weight: bold;
margin: 0em 0.9em !important;
padding: 0.6em 0.7em;
font-family: roboto, arial, tahoma, verdana, helvetica;
display: inline-block;
text-align: center;
cursor: pointer;
color: rgb(0,51,102);
background: rgb(204, 229,255);"" type="submit" value="Pausa">';
print '</form><br><br><br>';

// BEGIN MODULEBUILDER DRAFT MYOBJECT
if (! empty($conf->fichajes->enabled) && $user->rights->fichajes->read)
{
	$langs->load("orders");

	$sql = "SELECT *";
	$sql.= " FROM ".MAIN_DB_PREFIX."fichajes_log fl";
	$sql.= " WHERE fl.user_id = " . $user->id;
	$sql.= " ORDER BY fl.tms DESC";

	$resql = $db->query($sql);
	if ($resql)
	{
		$num = $db->num_rows($resql);

		print '<table class="noborder" width="100%">';
		print '<tr class="liste_titre">';
		print '<th colspan="3">Histórico de fichajes '.($num?' <span class="badge">'.$num.'</span>':'').'</th></tr>';

		if ($num > 0)
		{
			$i = 0;
			while ($i < $num)
			{

				$obj = $db->fetch_object($resql);
				print '<tr class="oddeven"><td class="nowrap">';
                print $obj->tms;
                print '</td>';
				print '<td class="nowrap">';
				print $obj->mov_type;
				print '</td>';
				print '<td align="right" class="nowrap">'.$obj->description.'</td></tr>';
				$i++;
			}
		}
		else
		{
			print '<tr class="oddeven"><td colspan="3" class="opacitymedium">No hay fichajes registrados.</td></tr>';
		}
		print "</table><br>";

		$db->free($resql);
	}
	else
	{
		dol_print_error($db);
	}
}


print '</div><div class="fichetwothirdright"><div class="ficheaddleft">';


$NBMAX=3;
$max=3;

/* BEGIN MODULEBUILDER LASTMODIFIED MYOBJECT
// Last modified myobject
if (! empty($conf->fichajes->enabled) && $user->rights->fichajes->read)
{
	$sql = "SELECT s.rowid, s.nom as name, s.client, s.datec, s.tms, s.canvas";
    $sql.= ", s.code_client";
	$sql.= " FROM ".MAIN_DB_PREFIX."societe as s";
	if (! $user->rights->societe->client->voir && ! $socid) $sql.= ", ".MAIN_DB_PREFIX."societe_commerciaux as sc";
	$sql.= " WHERE s.client IN (1, 2, 3)";
	$sql.= " AND s.entity IN (".getEntity($companystatic->element).")";
	if (! $user->rights->societe->client->voir && ! $socid) $sql.= " AND s.rowid = sc.fk_soc AND sc.fk_user = " .$user->id;
	if ($socid)	$sql.= " AND s.rowid = $socid";
	$sql .= " ORDER BY s.tms DESC";
	$sql .= $db->plimit($max, 0);

	$resql = $db->query($sql);
	if ($resql)
	{
		$num = $db->num_rows($resql);
		$i = 0;

		print '<table class="noborder" width="100%">';
		print '<tr class="liste_titre">';
		print '<th colspan="2">';
		if (empty($conf->global->SOCIETE_DISABLE_PROSPECTS) && empty($conf->global->SOCIETE_DISABLE_CUSTOMERS)) print $langs->trans("BoxTitleLastCustomersOrProspects",$max);
        else if (! empty($conf->global->SOCIETE_DISABLE_CUSTOMERS)) print $langs->trans("BoxTitleLastModifiedProspects",$max);
		else print $langs->trans("BoxTitleLastModifiedCustomers",$max);
		print '</th>';
		print '<th align="right">'.$langs->trans("DateModificationShort").'</th>';
		print '</tr>';
		if ($num)
		{
			while ($i < $num)
			{
				$objp = $db->fetch_object($resql);
				$companystatic->id=$objp->rowid;
				$companystatic->name=$objp->name;
				$companystatic->client=$objp->client;
                $companystatic->code_client = $objp->code_client;
                $companystatic->code_fournisseur = $objp->code_fournisseur;
                $companystatic->canvas=$objp->canvas;
				print '<tr class="oddeven">';
				print '<td class="nowrap">'.$companystatic->getNomUrl(1,'customer',48).'</td>';
				print '<td align="right" nowrap>';
				print $companystatic->getLibCustProspStatut();
				print "</td>";
				print '<td align="right" nowrap>'.dol_print_date($db->jdate($objp->tms),'day')."</td>";
				print '</tr>';
				$i++;


			}

			$db->free($resql);
		}
		else
		{
			print '<tr class="oddeven"><td colspan="3" class="opacitymedium">'.$langs->trans("None").'</td></tr>';
		}
		print "</table><br>";
	}
}
*/

print '</div></div></div>';

// End of page
llxFooter();
$db->close();
