<?php

require_once DOL_DOCUMENT_ROOT . '/custom/fichajes/lib/fichajes.lib.php';
require_once DOL_DOCUMENT_ROOT . '/custom/fichajes/class/enum/signing_trigger.class.php';
require_once DOL_DOCUMENT_ROOT . '/custom/fichajes/class/fichaje_timetable.class.php';

class Fichaje extends CommonObject
{
    /**
     * @var string ID to identify managed object
     */
    public $element = "fichaje";

    /**
     * @var string Name of table without prefix where object is stored
     */
    public $table_element = "fichajes_log";

    public $id;
    public $date;
    public $datef; // Date formatted

    public $userid;

    public $geoposition;

    public $type;

    public $description;

    /**
     *    Constructor
     *
     *  @param        DoliDB        $db      Database handler
     */
    public function __construct($db)
    {
        global $conf;
        $this->db = $db;
    }

    public function insert()
    {
        global $conf;

        $this->db->begin();

        if ($this->type == "Entrada") {
            $lastMovTypeSameDay = $this->getPrevious(true);
            if ($lastMovTypeSameDay != null && $lastMovTypeSameDay != "Salida" && ($lastMovTypeSameDay != "Pausa" || $lastMovTypeSameDay == "Pausa" && !$conf->global->FICHAJES_PAUSA_REQUIERE_NUEVA_ENTRADA)) {
                // Para un mismo día, no introducir una entrada a no ser que el último movimiento del día sea salida o sea pausa y FICHAJES_PAUSA_REQUIERE_NUEVA_ENTRADA
                $this->db->rollback();
                return;
            }

            if ($conf->global->FICHAJES_NO_COMPUTAR_ENTRADAS_ANTES_HORARIO_LABORAL) {
                // Obtener hora de entrada del día del fichaje
                $entryTime = $this->getEntryTime($this->db->idate($this->date));
                if ($entryTime != null) {
                    if (strtotime(date("H:i:s", $this->date)) < strtotime($entryTime)) {
                        $newDateTime = new DateTime(date("Y-m-d", $this->date));
                        $newDateTime->setTime(intval(substr($entryTime, 0, 2)), intval(substr($entryTime, 3, 2)), intval(substr($entryTime, 6, 2)));
                        $this->date = strtotime($newDateTime->format('Y-m-d H:i:s'));
                    }
                }
            }
        }

        if (!$conf->global->FICHAJES_GEOLOCALIZACION) {
            $this->geoposition = "";
        }

        $sql = "INSERT INTO " . MAIN_DB_PREFIX . "fichajes_log (user_id, tms, mov_type, mov_trigger, description, geoposition)
                VALUES (" . $this->userid . ", '" . $this->db->idate($this->date) . "', '" . $this->type . "', " . $this->trigger . ", '" . $this->db->escape($this->description) . "', '" . $this->geoposition . "')";

        dol_syslog(get_class($this) . "::create", LOG_DEBUG);
        $resql = $this->db->query($sql);
        if ($resql) {
            $this->db->commit();
        } else {
            $this->db->rollback();
        }
    }

    public function getEntryTime($date) {
        $weekDay = getDayOfWeekFromDate($date);
        $sql = "SELECT ft.entrytime FROM " . MAIN_DB_PREFIX . "fichajes_timetable ft WHERE day = " . $weekDay;
        $resql = $this->db->query($sql);
        if ($resql) {
            $nrows = $this->db->num_rows($resql);
            if ($nrows > 0) {
                $obj = $this->db->fetch_object($resql);
                return $obj->entrytime;
            }
        }

        return null;
    }

    public function update()
    {
        $sql = "UPDATE " . MAIN_DB_PREFIX . "fichajes_log SET description = '" . $this->description . "' WHERE rowid = " . $this->id;
        return $this->db->query($sql);
    }

    public function getPrevious($sameDay = false)
    {
        $sql = "SELECT fl.mov_type FROM " . MAIN_DB_PREFIX . "fichajes_log fl WHERE fl.user_id = " . $this->userid;
        if ($sameDay) {
            $sql .= " AND DATE(fl.tms) = DATE('" . $this->db->idate($this->date) . "')";
        }
        $sql .= " ORDER BY fl.tms DESC LIMIT 1";

        $resql = $this->db->query($sql);

        if ($resql) {
            $nrows = $this->db->num_rows($resql);
            if ($nrows > 0) {
                $obj = $this->db->fetch_object($resql);
                return $obj->mov_type;
            }
        }

        return null;
    }

    public function getNumberOfTotalSignings()
    {
        $sql = "SELECT COUNT(fl.rowid) as nSignings FROM " . MAIN_DB_PREFIX . "fichajes_log fl";
        
        $resql = $this->db->query($sql);

        if ($resql) {
            $num = $this->db->num_rows($resql);
            if ($num > 0) {
                $obj = $this->db->fetch_object($resql);
                return $obj->nSignings;
            }
        }

        return 0;
    }

    public function getAll($offset = 0, $limit = 0)
    {
        $signings = array();

        $sql = "SELECT fl.rowid, CONCAT(u.firstname, ' ', u.lastname) as username, fl.tms, fl.mov_type, fl.mov_trigger, fl.description, fl.geoposition 
                FROM " . MAIN_DB_PREFIX . "fichajes_log fl INNER JOIN " . MAIN_DB_PREFIX . "user u ON u.rowid = fl.user_id 
                ORDER BY fl.tms DESC";
        if ($limit > 0) {
            $sql.= " LIMIT " . $offset . "," . $limit;
        }

        $resql = $this->db->query($sql);

        if ($resql) {
            $num = $this->db->num_rows($resql);
            $i = 0;
        
            while ($i < $num) {
                $obj = $this->db->fetch_object($resql);
                $obj->tms = $this->db->jdate($obj->tms);
                $obj->datef = dol_print_date($obj->tms, '%d-%m-%Y %H:%M:%S');
                array_push($signings, $obj);
                $i++;
            }
        }

        return $signings;
    }

    public function getDailyRegister($month = null, $year = null)
    {
        if ($month == null) {
            $month = date("m");
        }

        if ($year == null) {
            $year = date("Y");
        }

        $sql = "SELECT fl.tms, fl.mov_type FROM " . MAIN_DB_PREFIX . "fichajes_log fl WHERE fl.user_id = " . $this->userid . " AND MONTH(fl.tms) = " . $month . " AND YEAR(fl.tms) = " . $year . " ORDER BY fl.tms ASC";

        $resql = $this->db->query($sql);

        $dailyEvents = array();
        $dailyRegister = array();

        if ($resql) {
            $nrows = $this->db->num_rows($resql);
            if ($nrows > 0) {
                while ($obj = $this->db->fetch_object($resql)) {
                    array_push($dailyEvents, $obj);
                }
            }

            $date = $year . "-" . $month . "-01";
            $monthDays = date('t', strtotime($date));

            $i = 1;
            while ($i <= $monthDays) {
                // Obtener tiempo de trabajo efectivo y de pausas
                $workedTime = 0;
                $pauseTime = 0;
                $lastEntryTime = null;
                $lastPauseTime = null;
                $lastMovType = null;

                foreach ($dailyEvents as $dailyEvent) {
                    $dailyEventDay = date("d", strtotime($dailyEvent->tms));

                    if ($dailyEventDay == $i) {
                        if ($dailyEvent->mov_type == "Entrada") {
                            if ($lastMovType == "Pausa") {
                                $pauseTime += getMinuteDiff($lastPauseTime, $dailyEvent->tms);
                            }
                            $lastEntryTime = $dailyEvent->tms;
                        } elseif ($dailyEvent->mov_type == "Salida") {
                            if ($lastEntryTime == null) {
                                // Debe haber una entrada el día anterior con salida el día siguiente
                                $sql = "SELECT MAX(fl.tms) tms, fl.mov_type FROM " . MAIN_DB_PREFIX . "fichajes_log fl WHERE fl.user_id = " . $this->userid . " AND DATE(fl.tms) = DATE_SUB('" . date("Y-m-d", strtotime($dailyEvent->tms)) . "', INTERVAL 1 DAY)";
                                $resql = $this->db->query($sql);
                                if ($resql) {
                                    $nrows = $this->db->num_rows($resql);
                                    if ($nrows > 0) {
                                        $obj = $this->db->fetch_object($resql);
                                        if ($obj->mov_type == 'Entrada') {
                                            $lastEntryTime = $obj->tms;

                                            // Sumar tiempo de trabajo al día anterior
                                            foreach ($dailyRegister as &$reg) {
                                                if ($reg['i'] == ($i-1)) {
                                                    $reg['workedTime'] += getMinuteDiff($lastEntryTime, $dailyEvent->tms);
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                            } else {
                                $workedTime += getMinuteDiff($lastEntryTime, $dailyEvent->tms);
                            }
                        } elseif ($dailyEvent->mov_type == "Pausa") {
                            $workedTime += getMinuteDiff($lastEntryTime, $dailyEvent->tms);
                            $lastPauseTime = $dailyEvent->tms;
                        } elseif ($dailyEvent->mov_type == "Reanudacion") {
                            $pauseTime += getMinuteDiff($lastPauseTime, $dailyEvent->tms);
                            $lastEntryTime = $dailyEvent->tms;
                        }

                        $lastMovType = $dailyEvent->mov_type;
                    } elseif ($dailyEventDay > $i) {
                        break;
                    }
                }

                $day = array("i" => $i, "workedTime" => $workedTime, "pauseTime" => $pauseTime);
                array_push($dailyRegister, $day);

                $i++;
            }
        }

        return $dailyRegister;
    }

    public function getFirstYear()
    {
        $sql = "SELECT YEAR(fl.tms) as year FROM " . MAIN_DB_PREFIX . "fichajes_log fl WHERE fl.user_id = " . $this->userid . " ORDER BY fl.tms DESC LIMIT 1";

        $resql = $this->db->query($sql);

        if ($resql) {
            $nrows = $this->db->num_rows($resql);
            if ($nrows > 0) {
                $obj = $this->db->fetch_object($resql);
                return $obj->year;
            }
        }

        return null;
    }

    public function doScheduledExit()
    {
        // Comprobar si hay salida el último día con entrada, y si no lo hay, autoasignar hora de salida
        $sql = "SELECT fl1.rowid, fl1.tms FROM
                    (SELECT fl.rowid, MAX(fl.tms) as tms FROM " . MAIN_DB_PREFIX . "fichajes_log fl WHERE fl.user_id = " . $this->userid . " AND fl.mov_type = 'Entrada' AND fl.tms < CURRENT_DATE()) as fl1
                    LEFT JOIN
                    (SELECT f2.rowid, f2.tms, f2.mov_type FROM " . MAIN_DB_PREFIX . "fichajes_log f2 WHERE f2.user_id = " . $this->userid . " AND f2.mov_type = 'Salida') as fl2 ON (DATE(fl1.tms) = DATE(fl2.tms) AND fl2.tms > fl1.tms)
                    WHERE DATE(fl1.tms) < CURRENT_DATE() AND fl2.tms IS NULL";

        $resql = $this->db->query($sql);

        if ($resql) {
            $nrows = $this->db->num_rows($resql);
            if ($nrows > 0) {
                $obj = $this->db->fetch_object($resql);

                $sql2 = "SELECT leavetime FROM " . MAIN_DB_PREFIX . "fichajes_timetable WHERE day = " . getDayOfWeekFromDate($obj->tms);
                $resql2 = $this->db->query($sql2);
                if ($resql2) {
                    $nrows2 = $this->db->num_rows($resql2);
                    if ($nrows2 > 0) {
                        $obj2 = $this->db->fetch_object($resql2);

                        $leaveDate = dol_mktime(substr($obj2->leavetime, 0, 2), substr($obj2->leavetime, 3, 2), 0, date("m", $this->db->jdate($obj->tms)), date("d", $this->db->jdate($obj->tms)), date("Y", $this->db->jdate($obj->tms)));
                        $fichaje = new Fichaje($this->db);
                        $fichaje->geoposition = "";
                        $fichaje->date = $leaveDate;
                        $fichaje->userid = $this->userid;
                        $fichaje->trigger = SigningTrigger::AUTO;
                        $fichaje->type = "Salida";
                        $fichaje->insert();
                    }
                }
            }
        }
    }
}
