<?php
/* Copyright (C) 2019 SuperAdmin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    fichajes/lib/fichajes.lib.php
 * \ingroup fichajes
 * \brief   Library files with common functions for Fichajes
 */

/**
 * Prepare admin pages header
 *
 * @return array
 */
function fichajesAdminPrepareHead()
{
    global $langs, $conf;

    $langs->load("fichajes@fichajes");

    $h = 0;
    $head = array();

    $head[$h][0] = dol_buildpath("/fichajes/admin/setup.php", 1);
    $head[$h][1] = $langs->trans("Settings");
    $head[$h][2] = 'settings';
    $h++;
    $head[$h][0] = dol_buildpath("/fichajes/admin/signings.php", 1);
    $head[$h][1] = $langs->trans("Signings");
    $head[$h][2] = 'signings';
    $h++;
    $head[$h][0] = dol_buildpath("/fichajes/admin/about.php", 1);
    $head[$h][1] = $langs->trans("About");
    $head[$h][2] = 'about';
    $h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    //$this->tabs = array(
    //    'entity:+tabname:Title:@fichajes:/fichajes/mypage.php?id=__ID__'
    //); // to add new tab
    //$this->tabs = array(
    //    'entity:-tabname:Title:@fichajes:/fichajes/mypage.php?id=__ID__'
    //); // to remove a tab
    complete_head_from_modules($conf, $langs, $object, $head, $h, 'fichajes');

    return $head;
}

function getDayOfWeekFromDate($date) 
{
    return date('N', strtotime($date));
}

function sendFile($filename)
{
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    header('Content-Type: ' . finfo_file($finfo, $filename));
    finfo_close($finfo);

    //Use Content-Disposition: attachment to specify the filename
    header('Content-Disposition: attachment; filename='.basename($filename));

    //No cache
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');

    //Define file size
    header('Content-Length: ' . filesize($filename));

    ob_clean();
    flush();
    readfile($filename);
}

function generateMapsLink($geoposition, $decode = 0)
{
    $coords = null;
    if ($decode) {
        $coords = explode(",", base64_decode($geoposition));
    } else {
        $coords = explode(",", $geoposition);
    }
    
    return 'https://www.google.com/maps/place/' . $coords[0] . ',' . $coords[1];
}

function findLastWorkingDay($today, $workingDays)
{
    $max = 7;
    $i = 0;
    while ($i < $max) {
        $lastWorkingDay = date('Y-m-d', strtotime('-1 day', strtotime($today)));
        $lastWorkingDayNumber = getDayOfWeekFromDate($lastWorkingDay);
        if (in_array($lastWorkingDayNumber, $workingDays)) {
            return $lastWorkingDay;
        }

        $lastWorkingDay = date('Y-m-d', strtotime('-1 day', strtotime($lastWorkingDay)));

        $i++;
    }
    
    return null;
}

function getGeoposition()
{
    if (isset($_COOKIE['geopos'])) {
        return base64_decode($_COOKIE['geopos']);
    }

    return null;
}

function getMinuteDiff($startDate, $endDate) 
{
    $time = new DateTime($startDate);
    $diff = $time->diff(new DateTime($endDate));
    return ($diff->h * 60) + $diff->i;
}

function showMonthPicker($selectedMonth = null, $selectedPage = null)
{
    global $langs;
    $langs->load("fichajes@fichajes");

    if ($selectedMonth == null) {
        $selectedMonth = date("n");
    }

    if ($selectedPage == null) {
        $selectedPage = 1;
    }

    $monthPicker = "
    <select id='monthPicker' name='month'>
        <option value='1'".($selectedMonth == 1 ? " selected" : '').">Enero</option>
        <option value='2'".($selectedMonth == 2 ? " selected" : '').">Febrero</option>
        <option value='3'".($selectedMonth == 3 ? " selected" : '').">Marzo</option>
        <option value='4'".($selectedMonth == 4 ? " selected" : '').">Abril</option>
        <option value='5'".($selectedMonth == 5 ? " selected" : '').">Mayo</option>
        <option value='6'".($selectedMonth == 6 ? " selected" : '').">Junio</option>
        <option value='7'".($selectedMonth == 7 ? " selected" : '').">Julio</option>
        <option value='8'".($selectedMonth == 8 ? " selected" : '').">Agosto</option>
        <option value='9'".($selectedMonth == 9 ? " selected" : '').">Septiembre</option>
        <option value='10'".($selectedMonth == 10 ? " selected" : '').">Octubre</option>
        <option value='11'".($selectedMonth == 11 ? " selected" : '').">Noviembre</option>
        <option value='12'".($selectedMonth == 12 ? " selected" : '').">Diciembre</option>
    </select>
    ";

    return $monthPicker;
}

function showYearPicker($firstYear = null, $selectedYear = null)
{
    global $langs;
    $langs->load("fichajes@fichajes");

    if ($selectedYear == null) {
        $selectedYear = date("n");
    }

    $thisYear = date("Y");

    if ($firstYear == null) {
        $firstYear = $thisYear;
    }

    print "<select name='year'>";
    $curYear = $firstYear;
    while ($curYear <= $thisYear) {
        print "<option value='".$curYear."'".($curYear == $selectedYear ? " selected" : "").">".$curYear."</option>";

        $curYear++;
    }
    print "</select>";
}

function formatMinutes($minutes, $format = '%02d:%02d')
{
    if ($minutes < 1) {
        return;
    }

    $hours = floor($minutes / 60);
    $minutes = ($minutes % 60);
    return sprintf($format, $hours, $minutes);
}
