<?php
/* Copyright (C) 2014-2021		Charlene BENKE	<charlene@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  \file	   htdocs/myschedule/admin/setup.php
 *  \ingroup	myschedule
 *  \brief	  Page d'administration-configuration du module myschedule
 */

$res=0;
if (! $res && file_exists("../../main.inc.php")) 
	$res=@include("../../main.inc.php");					// For root directory
if (! $res && file_exists("../../../main.inc.php")) 
	$res=@include("../../../main.inc.php");	// For "custom" directory

dol_include_once("/myschedule/core/lib/myschedule.lib.php");
require_once(DOL_DOCUMENT_ROOT."/core/lib/admin.lib.php");
require_once(DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php');

require_once(DOL_DOCUMENT_ROOT."/core/class/html.formadmin.class.php");
require_once(DOL_DOCUMENT_ROOT."/core/class/html.form.class.php");
require_once(DOL_DOCUMENT_ROOT."/core/class/html.formother.class.php");

$langs->load("admin");
$langs->load("other");
$langs->load("myschedule@myschedule");

// Security check
if (! $user->admin  ) accessforbidden();

$action = GETPOST('action', 'alpha');
$value = GETPOST('value', 'alpha');

$form = new Form($db);
$formother = new FormOther($db);

/*
 * Actions
 */


//if ($action == 'displayfichinterplanning' ) {
//	dolibarr_set_const($db, "MYSCHEDULE_DisplayFichinterPlanning", $value, 'chaine', 0, '', $conf->entity);
//	$mesg = "<font class='ok'>".$langs->trans("SettingSaved")."</font>";
//}
//$displayfichinterplanning=$conf->global->MYSCHEDULE_DisplayFichinterPlanning;

//if ($action == 'displayprojectplanning' ) {
//	dolibarr_set_const($db, "MYSCHEDULE_DisplayProjectPlanning", $value, 'chaine', 0, '', $conf->entity);
//	$mesg = "<font class='ok'>".$langs->trans("SettingSaved")."</font>";
//}
//$displayprojectplanning=$conf->global->MYSCHEDULE_DisplayProjectPlanning;

if ($action == 'openonothertab' ) {
	dolibarr_set_const($db, "MYSCHEDULE_openonothertab", $value, 'chaine', 0, '', $conf->entity);
	$mesg = "<font class='ok'>".$langs->trans("SettingSaved")."</font>";
}
$openonothertab=$conf->global->MYSCHEDULE_openonothertab;

if ($action == 'showsubordinateuser' ) {
	dolibarr_set_const($db, "MYSCHEDULE_showsubordinateuser", $value, 'chaine', 0, '', $conf->entity);
	$mesg = "<font class='ok'>".$langs->trans("SettingSaved")."</font>";
}
$showsubordinateuser=$conf->global->MYSCHEDULE_showsubordinateuser;


if ($action == 'setvalue') {

	dolibarr_set_const($db, "MYSCHEDULE_PeriodFilter",		GETPOST('periodfilter','text'),'chaine',0,'', $conf->entity);
	dolibarr_set_const($db, "MYSCHEDULE_colornouser", GETPOST('colornouser','text'),'chaine',0,'', $conf->entity);
	dolibarr_set_const($db, "MYSCHEDULE_colornotplanned", GETPOST('colornotplanned','text'),'chaine',0,'', $conf->entity);
	dolibarr_set_const($db, "MYSCHEDULE_colornotmade", GETPOST('colornotmade','text'),'chaine',0,'', $conf->entity);
	dolibarr_set_const($db, "MYSCHEDULE_colormade", GETPOST('colormade','text'),'chaine',0,'', $conf->entity);

	// gestion des durées d'affichage
	$duration = convertTime2Seconds(GETPOST('starthourdayhour', 'int'), GETPOST('starthourdaymin', 'int'));
	dolibarr_set_const($db, "MYSCHEDULE_startHourDay", $duration, 'chaine', 0, '', $conf->entity);
	$duration = convertTime2Seconds(GETPOST('endhourdayhour', 'int'), GETPOST('endhourdaymin', 'int'));
	dolibarr_set_const($db, "MYSCHEDULE_endHourDay", $duration, 'chaine', 0, '', $conf->entity);
	$duration = convertTime2Seconds(GETPOST('starthourworkhour', 'int'), GETPOST('starthourworkmin', 'int'));
	dolibarr_set_const($db, "MYSCHEDULE_startHourWork", $duration, 'chaine', 0, '', $conf->entity);
	$duration = convertTime2Seconds(GETPOST('endhourworkhour', 'int'), GETPOST('endhourworkmin', 'int'));
	dolibarr_set_const($db, "MYSCHEDULE_endHourWork", $duration, 'chaine', 0, '', $conf->entity);

	// save the setting
	dolibarr_set_const($db, "MYSCHEDULE_nbnewlineinter", GETPOST('nbnewlineinter','int'),'chaine',0,'', $conf->entity);
	dolibarr_set_const($db, "MYSCHEDULE_nbcontactonlist", GETPOST('nbcontactonlist','int'),'chaine',0,'', $conf->entity);

	dolibarr_set_const($db, "MYSCHEDULE_tiersexfipubnote", GETPOST('tiersexfipubnote','text'),'chaine',0,'', $conf->entity);
	dolibarr_set_const($db, "MYSCHEDULE_tiersexfiprivnote", GETPOST('tiersexfiprivnote','text'),'chaine',0,'', $conf->entity);
//	dolibarr_set_const($db, "MYSCHEDULE_NbHrsSuppMaxJrs",	GETPOST('NbHrsSuppMaxJrs','text'),'chaine',0,'', $conf->entity);
//	dolibarr_set_const($db, "MYSCHEDULE_NbHrsSuppMaxWeek", 	GETPOST('NbHrsSuppMaxWeek','text'),'chaine',0,'', $conf->entity);
	$mesg = "<font class='ok'>".$langs->trans("GeneralSettingSaved")."</font>";
//} elseif ($action == 'setuserpdfvalue') {
//	dolibarr_set_const($db, "MYSCHEDULE_FormatDisplayMode",		GETPOST('formatdisplaymode','text'),'chaine',0,'', $conf->entity);
//	$mesg = "<font class='ok'>".$langs->trans("PdfSettingSaved")."</font>";

}



$nbnewlineinter=$conf->global->MYSCHEDULE_nbnewlineinter;
$nbcontactonlist=$conf->global->MYSCHEDULE_nbcontactonlist;

$colornouser=$conf->global->MYSCHEDULE_colornouser; //lightcoral
$colornotplanned=$conf->global->MYSCHEDULE_colornotplanned; // sandybrown
$colornotmade=$conf->global->MYSCHEDULE_colornotmade; // lightgreen
$colormade=$conf->global->MYSCHEDULE_colormade; //lightgrey
$periodfilter=$conf->global->MYSCHEDULE_PeriodFilter;
//$formatdisplaymode=$conf->global->MYSCHEDULE_FormatDisplayMode;

$startHourDay=$conf->global->MYSCHEDULE_startHourDay;
$endHourDay=$conf->global->MYSCHEDULE_endHourDay;
$startHourWork=$conf->global->MYSCHEDULE_startHourWork;
$endHourWork=$conf->global->MYSCHEDULE_endHourWork;



/*
 * View
 */
$help_url='http://wiki.patas-monkey.com/index.php?title=MySchedule#Param.C3.A9trage';

$page_name = $langs->trans("myScheduleSetup") . " - " . $langs->trans("GeneralSetting");
llxHeader('', $page_name, $help_url);

$linkback='<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
print load_fiche_titre($page_name, $linkback, 'title_setup');



$head = myschedule_admin_prepare_head();

dol_fiche_head($head, 'setup', $langs->trans("myschedule"), -1, "myschedule@myschedule");



print_titre($langs->trans("myScheduleSettingValue"));


print '<div class="fichecenter"><div class="fichehalfleft">';
print '<div class="underbanner clearboth"></div>';

print '<form method="post" action="setup.php">';
print '<input type="hidden" name="action" value="setvalue">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<table class="noborder" width=100%>';
print '<tr class="liste_titre">';
print '<td width=70% align=left>'.$langs->trans("Description").'</td>';
print '<td align=left>'.$langs->trans("Value").'</td>';
print '</tr>'."\n";

print '<tr >';
print '<td align=left>'.$langs->trans("DefaultPeriodFilter").'</td>';
print '<td  align=left>';
$periodFilterArray = array(
				'week'=>$langs->trans('Week'),
				'month'=>$langs->trans('Month'),
);
 print $form->selectarray(
				"periodfilter", $periodFilterArray, $periodfilter, 
				0, 0, 0, '', 0, 0, 0, '', '', 1
);
print '</td></tr>'."\n";

print '<tr><td align=left>'.$langs->trans("NoUserAffectedColor").'</td>';
print '<td align=left>';
print $formother->selectColor($colornouser, 'colornouser', 'colornouser', 1, '', 'hideifnotset');
print '</td></tr>'."\n";
print '<tr><td align=left>'.$langs->trans("NotPlannedColor").'</td>';
print '<td align=left>';
print $formother->selectColor($colornotplanned, 'colornotplanned', 'colornotplanned', 1, '', 'hideifnotset');
print '</td></tr>'."\n";
print '<tr><td align=left>'.$langs->trans("NotMadeColor").'</td>';
print '<td align=left>';
print $formother->selectColor($colornotmade, 'colornotmade', 'colornotmade', 1, '', 'hideifnotset');
print '</td></tr>'."\n";
print '<tr><td align=left>'.$langs->trans("MadeColor").'</td>';
print '<td align=left>';
print $formother->selectColor($colormade, 'colormade', 'colormade', 1, '', 'hideifnotset');
print '</td></tr>'."\n";

print '<tr >';
print '<td align=left>'.$langs->trans("NbLineOnNewFichInter").'</td>';
print '<td  align=left>';
print $form->selectarray(
	"nbnewlineinter", array('1'=>1, '2'=>2, '3'=>3), $nbnewlineinter, 
	0, 0, 0, '', 0, 0, 0, '', '', 0
);
print '</td></tr>'."\n";

print '<tr >';
print '<td align=left>'.$langs->trans("NbContactOnList").'</td>';
print '<td  align=left>';
print $form->selectarray(
	"nbcontactonlist", array('0'=>0, '1'=>1, '2'=>2, '3'=>3), $nbcontactonlist, 
	0, 0, 0, '', 0, 0, 0, '', '', 0
);
print '</td></tr>'."\n";

print '</table>';

print '</div><div class="fichehalfright"><div class="ficheaddleft">';
//print '<div class="underbanner clearboth"></div>';
print '<table class="noborder" width="100%">';
print '<tr class="liste_titre">';
print '<td width=70% align=left>'.$langs->trans("Description").'</td>';
print '<td align=left>'.$langs->trans("Value").'</td>';
print '</tr>'."\n";

print '<tr >';
print '<td align=left>'.$langs->trans("StartHourDay").'</td>';
print '<td  align=left>';
// heure de début et de fin de la vue semaine
$form->select_duration('starthourday', $startHourDay, 0, 'select');
print '</td></tr>'."\n";

print '<tr >';
print '<td align=left>'.$langs->trans("StartHourWork").'</td>';
print '<td  align=left>';
// heure de début et de fin de la vue semaine
$form->select_duration('starthourwork', $startHourWork, 0, 'select');
print '</td></tr>'."\n";
print '<tr >';
print '<td align=left>'.$langs->trans("EndHourWork").'</td>';
print '<td  align=left>';
// heure de début et de fin de la vue semaine
$form->select_duration('endhourwork', $endHourWork, 0, 'select');
print '</td></tr>'."\n";

print '<tr >';
print '<td align=left>'.$langs->trans("EndHourDay").'</td>';
print '<td  align=left>';
// heure de début et de fin de la vue semaine
$form->select_duration('endhourday', $endHourDay, 0, 'select');
print '</td></tr>'."\n";


$extrafields = new ExtraFields($db);
$extrafields->fetch_name_optionals_label('societe');
print '<tr >';
print '<td align=left>'.$langs->trans("SelectExtrafieldThirdpartyForPublicNote").'</td>';
print '<td  align=left>';
if (! empty($extrafields->attributes['societe']['type'])) {
	print "<select name=tiersexfipubnote>";
	print "<option value=''>".$langs->trans("None")."</option>";
	foreach ($extrafields->attributes['societe']['type'] as $key => $value) {
		print "<option value=".$key." ".($conf->global->MYSCHEDULE_tiersexfipubnote == $key ?'selected':'')." >";
		print $extrafields->attributes['societe']['label'][$key]."</option>";
	}
	print "</select>";	
} else 
	print $langs->trans("None");	

print '</td></tr>'."\n";

print '<tr >';
print '<td align=left>'.$langs->trans("SelectExtrafieldThirdpartyForPrivateNote").'</td>';
print '<td  align=left>';
if (! empty($extrafields->attributes['societe']['type'])) {
	print "<select name=tiersexfiprivnote>";
	print "<option value=''>".$langs->trans("None")."</option>";
	foreach ($extrafields->attributes['societe']['type'] as $key => $value) {
		print "<option value=".$key." ".($conf->global->MYSCHEDULE_tiersexfiprivnote == $key ?'selected':'')." >";
		print $extrafields->attributes['societe']['label'][$key]."</option>";
	}
	print "</select>";	
} else
	print $langs->trans("None");	
print '</td></tr>'."\n";

// plus d'actualité pour le moment
if (false) {
	
$NbHrsMorningHoliday=$conf->global->MYSCHEDULE_NbHrsMorningHoliday;
$NbHrsAfternoonHoliday=$conf->global->MYSCHEDULE_NbHrsAfternoonHoliday;
$NbHrsMaxJrs=$conf->global->MYSCHEDULE_NbHrsMaxJrs;
$NbHrsMaxWeek=$conf->global->MYSCHEDULE_NbHrsMaxWeek;
$NbHrsSuppMaxJrs=$conf->global->MYSCHEDULE_NbHrsSuppMaxJrs;
$NbHrsSuppMaxWeek=$conf->global->MYSCHEDULE_NbHrsSuppMaxWeek;

	print '<tr >';
	print '<td align=left>'.$langs->trans("NbHrsMorningHoliday").'</td>';
	print '<td  align=left>';
	print $form->select_duration('NbHrsMorningHoliday', $NbHrsMorningHoliday, 0);
	print '</td></tr>'."\n";
	print '<tr >';
	print '<td align=left>'.$langs->trans("NbHrsAfternoonHoliday").'</td>';
	print '<td  align=left>';
	print $form->select_duration('NbHrsAfternoonHoliday', $NbHrsAfternoonHoliday, 0);
	print '</td></tr>'."\n";

	print '<tr >';
	print '<td align=left>'.$langs->trans("NbHrsMaxJour").'</td>';
	print '<td  align=left>';
	print $form->select_duration('NbHrsMaxJrs', $NbHrsMaxJrs, 0);
	print '</td></tr>'."\n";

	print '<tr >';
	print '<td align=left>'.$langs->trans("NbHrsMaxSemaine").'</td>';
	print '<td  align=left>';
	print $form->select_duration('NbHrsMaxWeek', $NbHrsMaxWeek, 0, 'textselect');
	print '</td></tr>'."\n";

	print '<tr >';
	print '<td align=left>'.$langs->trans("NbHrsSuppMaxJour").'</td>';
	print '<td  align=left>';
	print $form->select_duration('NbHrsSuppMaxJrs', $NbHrsSuppMaxJrs, 0);
	print '</td></tr>'."\n";

	print '<tr >';
	print '<td align=left>'.$langs->trans("NbHrsSuppMaxSemaine").'</td>';
	print '<td  align=left>';
	print $form->select_duration('NbHrsSuppMaxWeek', $NbHrsSuppMaxWeek, 0, 'textselect');
	print '</td></tr>'."\n";
}

print '<tr >';
print '<td align=left>'.$langs->trans("OpenOnOtherTabs").'</td>';
print '<td  align=left>';
if ( $openonothertab == "1") {
	print '<a href="'.$_SERVER["PHP_SELF"].'?action=openonothertab&value=0">';
	print img_picto($langs->trans("Enabled"), 'switch_on').'</a>';
} else {
	print '<a href="'.$_SERVER["PHP_SELF"].'?action=openonothertab&value=1">';
	print img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
}
print '</td></tr>'."\n";

print '<tr >';
print '<td align=left>'.$langs->trans("ShowSubordinateUser").'</td>';
print '<td  align=left>';
if ( $showsubordinateuser == "1") {
	print '<a href="'.$_SERVER["PHP_SELF"].'?action=showsubordinateuser&value=0">';
	print img_picto($langs->trans("Enabled"), 'switch_on').'</a>';
} else {
	print '<a href="'.$_SERVER["PHP_SELF"].'?action=showsubordinateuser&value=1">';
	print img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
}
print '</td></tr>'."\n";

print '</table>';
print '</div></div>';
print '<div class="clearboth"></div>';



// Boutons d'action
print '<div class="tabsAction">';
print '<input type="submit" class="button" value="'.$langs->trans("Modify").'">';
print '</div>';

print '</form>';

// skip check version of our modules
if ($action == 'patasMonkeySkipCheckVersion') {
	dolibarr_set_const($db, "PATASMONKEY_SKIP_CHECKVERSION", GETPOST('value'), 'chaine', 0, '', $conf->entity);
}
$patasMonkeySkipCheckVersion=(!empty($conf->global->PATASMONKEY_SKIP_CHECKVERSION)?$conf->global->PATASMONKEY_SKIP_CHECKVERSION:0);
print '<table class="noborder" width="100%">'."\n";
print '<tr class="liste_titre">';

print '<td width="350px">'.$langs->trans("PatasMonkeySkipCheckVersion").'</td>';
print '<td>'.$langs->trans("InfoPatasMonkeySkipCheckVersion").'</td>';
print '<td width=100px align=left>';
if ( $patasMonkeySkipCheckVersion == 1) {
	print '<a href="'.$_SERVER["PHP_SELF"].'?action=patasMonkeySkipCheckVersion&value=0">';
	print img_picto($langs->trans("Enabled"), 'switch_on').'</a>';
} else {
	print '<a href="'.$_SERVER["PHP_SELF"].'?action=patasMonkeySkipCheckVersion&value=1">';
	print img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
}
print '</td></tr>';
print "</table>";
/*
 *  Infos pour le support
 */
//print '<br>';//
libxml_use_internal_errors(true);
$sxe = simplexml_load_string(nl2br(file_get_contents('../changelog.xml')));
if ($sxe === false) {
	echo "Erreur lors du chargement du XML\n";
	foreach (libxml_get_errors() as $error) 
		print $error->message;
	exit;
} else
	$tblversions=$sxe->Version;

$currentversion = $tblversions[count($tblversions)-1];

print '<table class="noborder" width="100%">'."\n";
print '<tr class="liste_titre">'."\n";
print '<td width=20%>'.$langs->trans("SupportModuleInformation").'</td>'."\n";
print '<td>'.$langs->trans("Value").'</td>'."\n";
print "</tr>\n";
print '<tr ><td >'.$langs->trans("DolibarrVersion").'</td><td>'.DOL_VERSION.'</td></tr>'."\n";
print '<tr ><td >'.$langs->trans("ModuleVersion").'</td>';
print '<td>'.$currentversion->attributes()->Number." (".$currentversion->attributes()->MonthVersion.')</td></tr>'."\n";
print '<tr ><td >'.$langs->trans("PHPVersion").'</td><td>'.version_php().'</td></tr>'."\n";
print '<tr ><td >'.$langs->trans("DatabaseVersion").'</td>';
print '<td>'.$db::LABEL." ".$db->getVersion().'</td></tr>'."\n";
print '<tr ><td >'.$langs->trans("WebServerVersion").'</td>';
print '<td>'.$_SERVER["SERVER_SOFTWARE"].'</td></tr>'."\n";
print '<tr>'."\n";
print '<td colspan="2" align=center ><em><b>'.$langs->trans("SupportModuleInformationDesc").'</b></em></td></tr>'."\n";
print "</table>\n";


// Show messages
dol_htmloutput_mesg($mesg, '', 'ok');

// Footer
llxFooter();
$db->close();