<?php
/* Copyright (C) 2014-2018		Charlene BENKE	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	  \file	   management/class/managementdailytime.class.php
 *	  \ingroup	management
 *	  \brief	pour grer la transfert en facturation du projet
 */

require_once DOL_DOCUMENT_ROOT."/core/class/commonobject.class.php";

/**
 *	  \brief	  Class to manage tasks
 *	\remarks	Initialy built by build_class_from_table on 2008-09-10 12:41
 */
class Dailytime extends CommonObject
{
	public $element='user_dailytime';
	var $fk_user;
	var $date_start;
	var $monday_am;
	var $monday_pm;
	var $monday_closeday;
	var $tuesday_am;
	var $tuesday_pm;
	var $tuesday_closeday;
	var $wednesday_am;
	var $wednesday_pm;
	var $wednesday_closeday;
	var $thursday_am;
	var $thursday_pm;
	var $thursday_closeday;
	var $friday_am;
	var $friday_pm;
	var $friday_closeday;
	var $saturday_am;
	var $saturday_pm;
	var $saturday_closeday;
	var $sunday_am;
	var $sunday_pm;
	var $sunday_closeday;

	/**
	 *  Constructor
	 *
	 *  @param	  DoliDB		$db	  Database handler
	 */
	function __construct($db)
	{
		$this->db = $db;
	}

	function insert()
	{
		global $user;

		$sql = "INSERT ". MAIN_DB_PREFIX . "user_dailytime (fk_user, date_start,";
		$sql.= " monday_am, monday_pm, monday_closeday,";
		$sql.= " tuesday_am, tuesday_pm, tuesday_closeday,";
		$sql.= " wednesday_am, wednesday_pm, wednesday_closeday,";
		$sql.= " thursday_am, thursday_pm, thursday_closeday,";
		$sql.= " friday_am, friday_pm, friday_closeday,";
		$sql.= " saturday_am, saturday_pm, saturday_closeday,";
		$sql.= " sunday_am, sunday_pm, sunday_closeday";
		$sql.= " ) VALUES ( " ;
		$sql.= " ".$this->fk_user;
		$sql.= ", ".($this->date_start?"'".$this->db->idate($this->date_start)."'":null);
		$sql.= ", ".$this->monday_am.", ".$this->monday_pm.", ".$this->monday_closeday;
		$sql.= ", ".$this->tuesday_am.", ".$this->tuesday_pm.", ".$this->tuesday_closeday;
		$sql.= ", ".$this->wednesday_am.", ".$this->wednesday_pm.", ".$this->wednesday_closeday;
		$sql.= ", ".$this->thursday_am.", ".$this->thursday_pm.", ".$this->thursday_closeday;
		$sql.= ", ".$this->friday_am.", ".$this->friday_pm.", ".$this->friday_closeday;
		$sql.= ", ".$this->saturday_am.", ".$this->saturday_pm.", ".$this->saturday_closeday;
		$sql.= ", ".$this->sunday_am.", ".$this->sunday_pm.", ".$this->sunday_closeday;
		$sql.=")";
//print $sql;
		$resql = $this->db->query($sql);
		if (! $resql) {
			$this->error="Error ".$this->db->lasterror();
			dol_syslog(get_class($this)."::INSERT ".$this->error, LOG_ERR);
			return -1;
		}

		return 1;
	}

	function update($id)
	{
		global $user;

		// on regarde si on change un date existante ou 
		$tmpdailytime = new Dailytime($this->db);
		$tmpdailytime->fetch($id, $this->date_start);
		if ($tmpdailytime->fk_user > 0) {
		
			$sql = "UPDATE ". MAIN_DB_PREFIX . "user_dailytime ";
			$sql.= " set monday_am = ".$this->monday_am;
			$sql.= " , monday_pm = ".$this->monday_pm;
			$sql.= " , monday_closeday = ".$this->monday_closeday;

			$sql.= " , tuesday_am = ".$this->tuesday_am;
			$sql.= " , tuesday_pm = ".$this->tuesday_pm;
			$sql.= " , tuesday_closeday = ".$this->tuesday_closeday;

			$sql.= " , wednesday_am = ".$this->wednesday_am;
			$sql.= " , wednesday_pm = ".$this->wednesday_pm;
			$sql.= " , wednesday_closeday = ".$this->wednesday_closeday;

			$sql.= " , thursday_am = ".$this->thursday_am;
			$sql.= " , thursday_pm = ".$this->thursday_pm;
			$sql.= " , thursday_closeday = ".$this->thursday_closeday;

			$sql.= " , friday_am = ".$this->friday_am;
			$sql.= " , friday_pm = ".$this->friday_pm;
			$sql.= " , friday_closeday = ".$this->friday_closeday;

			$sql.= " , saturday_am = ".$this->saturday_am;
			$sql.= " , saturday_pm = ".$this->saturday_pm;
			$sql.= " , saturday_closeday = ".$this->saturday_closeday;

			$sql.= " , sunday_am = ".$this->sunday_am;
			$sql.= " , sunday_pm = ".$this->sunday_pm;
			$sql.= " , sunday_closeday = ".$this->sunday_closeday;

	//  la cl unique c'est l'user et la date_start
			$sql.= " WHERE fk_user=".$this->fk_user;
			$sql.= " AND date_start = '".$this->db->idate($this->date_start)."'";
		
		} else
			$this->insert();

		$resql = $this->db->query($sql);
		if (! $resql) {
			$this->error="Error ".$this->db->lasterror();
			dol_syslog(get_class($this)."::INSERT ".$this->error, LOG_ERR);
			return -1;
		}

		return 1;

	}


	
	function fetch($id, $date_start="")
	{
		// on rcupre les taches termines du projet

		// on ne rcupre que les lignes  facturer qui ne sont pas encore associ  une facture
		$sql = "SELECT * FROM ".MAIN_DB_PREFIX."user_dailytime as udt" ;
		$sql.= " WHERE udt.fk_user =".$id;
		if ($date_start)	// on prend toujours les dates infrieur 
			$sql.= " WHERE udt.date_start < '".$date_start;
		// et la plus grande de celle-ci (la dernire)
		$sql.= " ORDER BY date_start desc";

		dol_syslog(get_class($this)."::fetch_lines sql=".$sql, LOG_DEBUG);
		$resql=$this->db->query($sql);
		if ($resql) {
			$result = $this->db->fetch_array($resql);

			if ($result) {
				$this->fk_user				= $result["fk_user"];
				$this->date_start			= $result["date_start"];

				$this->monday_am			= $result["monday_am"];
				$this->monday_pm			= $result["monday_pm"];
				$this->monday_closeday		= $result["monday_closeday"];

				$this->tuesday_am			= $result["tuesday_am"];
				$this->tuesday_pm			= $result["tuesday_pm"];
				$this->tuesday_closeday		= $result["tuesday_closeday"];

				$this->wednesday_am			= $result["wednesday_am"];
				$this->wednesday_pm			= $result["wednesday_pm"];
				$this->wednesday_closeday	= $result["wednesday_closeday"];

				$this->thursday_am			= $result["thursday_am"];
				$this->thursday_pm			= $result["thursday_pm"];
				$this->thursday_closeday	= $result["thursday_closeday"];

				$this->friday_am			= $result["friday_am"];
				$this->friday_pm			= $result["friday_pm"];
				$this->friday_closeday		= $result["friday_closeday"];

				$this->saturday_am			= $result["saturday_am"];
				$this->saturday_pm			= $result["saturday_pm"];
				$this->saturday_closeday	= $result["saturday_closeday"];

				$this->sunday_am			= $result["sunday_am"];
				$this->sunday_pm			= $result["sunday_pm"];
				$this->sunday_closeday		= $result["sunday_closeday"];

			} else
				return $this->fetch(0);

			$this->db->free($resql);
		} else {
			$this->error="Error ".$this->db->lasterror();
			dol_syslog(get_class($this)."::fetch".$this->error, LOG_ERR);

			return -1;
		}
		return $this->fk_user;
	}

	// retourne un tableau avec en paramtre des heures total par jour et si clos
	function fetchArray($id)
	{
		$this->fetch($id);
		$arrayday = array(	'1'=> $this->monday_am + $this->monday_pm,
							'2'=> $this->tuesday_am + $this->tuesday_pm,
							'3'=> $this->wednesday_am + $this->wednesday_pm,
							'4'=> $this->thursday_am + $this->thursday_pm,
							'5'=> $this->friday_am + $this->friday_pm,
							'6'=> $this->saturday_am + $this->saturday_pm,
							'0'=> $this->sunday_am + $this->sunday_pm
						);
		return $arrayday;
	}
}
