<?php
/* Copyright (C) 2014-2018	Charlene BENKE	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *		\file	   htdocs/myschedule/core/lib/myschedule.lib.php
 *		\brief	  Ensemble de fonctions de base for myschedule
 */

/**
 *  Return array head with list of tabs to view object informations
 *
 *  @param	Object	$object		 Member
 *  @return array		   		head
 */
function myschedule_admin_prepare_head ()
{
	global $langs, $conf, $user;
	
	$h = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/myschedule/admin', 1).'/setup.php';
	$head[$h][1] = $langs->trans("Setup");
	$head[$h][2] = 'setup';

	$h++;
	$head[$h][0] = dol_buildpath('/myschedule/', 1).'/userdailytime.php?id=0';
	$head[$h][1] = $langs->trans("DefaultUserDaily");
	$head[$h][2] = 'userdaily';

	$h++;
	$head[$h][0] = dol_buildpath('/myschedule/admin', 1).'/about.php';
	$head[$h][1] = $langs->trans("About");
	$head[$h][2] = 'about';

	return $head;
}

/**
 *	  Return HTML combo list of week
 *
 *	  @param  string	  $selected		  Preselected value
 *	  @param  string	  $htmlname		  Name of HTML select object
 *	  @param  int		 $useempty		  Show empty in list
 *	  @param  int		 $longlabel		 Show long label
 *	  @return string
 */
function select_week($selected='', $htmlname='weekid', $useempty=0)
{
	require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
	$select_week = '<select class="flat" name="'.$htmlname.'" id="'.$htmlname.'">';
	if ($useempty)
		$select_week .= '<option value="0">&nbsp;</option>';

	for ( $week=1; $week < 54; $week++) {
		$selectedoption="";
		if ($selected == $week)
			$selectedoption=" selected ";
		$select_week .= '<option value="'.$week.'" '.$selectedoption.'>';
		$select_week .= $week;
		$select_week .= '</option>';
	}
	$select_week .= '</select>';
	return $select_week;
}


/**
 *  return time passed on a task for a day and a user
 *
 *  @param	int		$fk_task	project task id
 *  @param	date	$curday 	current day
 *  @param	int		$fk_user 	user id
 *  @return int					duration in seconds
 */
function fetchSumTimePlanned($fk_task, $curday, $fk_user=0, $displaymode=0)
{
	global $db;

	if ($displaymode=="0") {
		$sql = "SELECT sum(pts.task_duration) as total";
		$sql.= " FROM ".MAIN_DB_PREFIX."projet_task as pt";
		$sql.= " , ".MAIN_DB_PREFIX."projet_task_schedule as pts" ;
		$sql.= " WHERE pts.fk_task = pt.rowid";
	} elseif ($displaymode=="2") {
		$sql = "SELECT sum((pts.task_duration/3600)*p.price) as total";
		$sql.= " FROM ".MAIN_DB_PREFIX."projet_task as pt, ".MAIN_DB_PREFIX."product as p" ;
		$sql.= " , ".MAIN_DB_PREFIX."projet_task_schedule as pts" ;
		$sql.= " WHERE pt.fk_product = p.rowid AND pts.fk_task = pt.rowid";
	}

	$sql.= " AND pt.rowid= ".$fk_task;
	if ($curday) {
		$sql.= " AND pts.task_date = '".$db->idate($curday)."'";
	}
	// le temps assigné à l'utilisateur
	if ($fk_user > 0)
		$sql.= " AND pts.fk_user= ".$fk_user;

	dol_syslog("management.lib::fetchSumTimePlanned sql=".$sql, LOG_DEBUG);
	$resql=$db->query($sql);
	if ($resql) {
		if ($db->num_rows($resql)) {
			$obj = $db->fetch_object($resql);
			$duration= $obj->total;
		}
		$db->free($resql);
		return $duration;
	}
	return 0;
}

function fetchTextTimePlanned($fk_task, $curday, $fk_user)
{
	global $db;
	$note="";
	$sql = "SELECT t.note";
	$sql.= " FROM ".MAIN_DB_PREFIX."projet_task_schedule as t";
	$sql.= " WHERE t.fk_task= ".$fk_task;
	$sql.= " AND t.task_date ='".$db->idate($curday)."'";
	$sql.= " AND t.fk_user= ".$fk_user;

	dol_syslog("management.lib::fetchTextTimeSpent sql=".$sql, LOG_DEBUG);
	$resql=$db->query($sql);
	if ($resql) {
		if ($db->num_rows($resql)) {
			$num = $db->num_rows($resql);
			$i = 0;
			// Loop on each record found, so each couple (project id, task id)
			while ($i < $num) {
				$obj = $db->fetch_object($resql);
				if ($obj->note)
					$note.= $obj->note."\n";
				$i++;
			}
		}
		$db->free($resql);
		return $note;
	}
	return 0;
}

// retour le premier jour d'une semaine donnée
function firstdayweek($periodweek, $periodyear) {
	$tsPremierJanvier = strtotime($periodyear . '-01-01');
	$jourPremierJanvier = date('w', $tsPremierJanvier);

	//-- recherche du N° de semaine du 1er janvier -------------------
	$numWeekPremierJanvier = date('W', $tsPremierJanvier);

	//-- nombre à ajouter en fonction du numéro précédent ------------
	$decallage = ($numWeekPremierJanvier == 1) ? $periodweek - 1 : $periodweek;
	//-- timestamp du jour dans la semaine recherchée ----------------
	$timeStampDate = strtotime('+' . $decallage . ' weeks', $tsPremierJanvier);
	//-- recherche du lundi de la semaine en fonction de la ligne précédente ---------
	return ($jourPremierJanvier == 1) ?  $timeStampDate : strtotime('last monday', $timeStampDate);
}