<?php
/* Copyright (C) 2013-2021	Charlene BENKE	<charlie@patas-monkey.com>
*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file	   	htdocs/myschedule/fichinter/massjobmade.php
 *	\ingroup		myschedule
 *	\brief	  	Page of fichinter myschedule jobmade
 */

$res=0;
if (! $res && file_exists("../../main.inc.php")) 
	$res=@include("../../main.inc.php");		// For root directory
if (! $res && file_exists("../../../main.inc.php")) 
	$res=@include("../../../main.inc.php");	// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/fichinter/class/fichinter.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';

if ($conf->projet->enabled)
	require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';

if ($conf->contrat->enabled)
	require_once DOL_DOCUMENT_ROOT.'/contrat/class/contrat.class.php';


//require_once DOL_DOCUMENT_ROOT."/holiday/class/holiday.class.php";

dol_include_once('/myschedule/core/lib/myschedule.lib.php');
dol_include_once('/myschedule/class/myschedule.class.php');

$langs->load('companies');
$langs->load('interventions');
$langs->load('bills');
$langs->load('myschedule@myschedule');

$error=0;

$id 	= GETPOST('id', 'int');
$ref 	= GETPOST('ref', 'alpha');
$action	= GETPOST('action', 'alpha');

// si non renseigné on prend le paramétre par défaut TODO, à valider
$choiceperiod= GETPOST('choiceperiod')?GETPOST('choiceperiod', 'alpha'):'week';
$firstdayweek= GETPOST('firstdayweek')?strtotime( GETPOST('firstdayweek', 'alpha')):"";


$perioduser=GETPOST('perioduser', 'int');
if (!$perioduser && $user->admin == 0  && $user->rights->myschedule->alluser == 0)
	$perioduser=$user->id;

$periodsoc=GETPOST('periodsoc', 'int');
if ($periodsoc ==0 && ! empty($user->societe_id))
	$periodsoc = $user->societe_id;


$dolstatut=GETPOST('dolstatut')?GETPOST('dolstatut', 'int'):-1;

// on affiche seulement les events pas encore réalisé et planifié 
$filterbystatut = explode(",", "notmade,notplanned");

$periodyear=GETPOST('periodyear', 'int');
if (!$periodyear)
	$periodyear=date('Y');

$periodyearmonth=GETPOST('periodyearmonth', 'int');
if (!$periodyearmonth)
	$periodyearmonth=date('Y');

$periodmonth=GETPOST('periodmonth', 'int');
if (! $periodmonth )
	$periodmonth=date('m');

$periodweek=GETPOST('periodweek', 'int');
if (!$periodweek)
	$periodweek=date('W');

if ($choiceperiod == 'week') {
	if ($firstdayweek == "") 
		$firstdayweek = firstdayweek($periodweek, $periodyear);
	else
		$periodweek = date("W", $firstdayweek);

	$periodmonth=date('m', $firstdayweek);
	$lastdayweek = strtotime(date("Y-m-d", strtotime(date('d-m-Y', $firstdayweek)))." +6 day"); 

	$fullcalendarfirstday=date("Y-m-d", $firstdayweek);
	$fullcalendarlastday=date("Y-m-d", $lastdayweek);	
} 
if ($choiceperiod=='month') {
	$fullcalendarfirstday=date("Y-m-d", dol_mktime(0, 0, 0, $periodmonth, 1, $periodyearmonth));
	$fullcalendarlastday=date("Y-m-d", dol_mktime(0, 0, 0, $periodmonth, 30, $periodyearmonth));
} 

// Security check
if (! empty($user->societe_id))
	$socid=$user->societe_id;
$result = restrictedArea($user, 'ficheinter', $id, 'fichinter');

/*
 * View
 */
$arrayofcss = array
	( '/myschedule/js/main.min.css'
);

$arrayofjs = array
	( '/myschedule/js/main.min.js'
	, '/myschedule/js/moment.min.js'
	, '/myschedule/js/locales/fr.js'
);

llxHeader('', "", "", '', 0, 0, $arrayofjs, $arrayofcss, '');


$form = new Form($db);
if ($conf->projet->enabled)
	$projet_static = new Project($db);
if ($conf->contrat->enabled)
	$contrat_static = new Contrat($db);

$now=dol_now();

/*
 * Show object in view mode
 */
$title=$langs->trans("mySchedule")." - ".$langs->trans("MassPlanification");

print load_fiche_titre($title, "", 'myschedule@myschedule');

print '<form method="POST" name=massaction >';

print '<table class="noborder" >';
print '<tr><td valign=top width=25%><h2>';
// ici la période actuelle
if( $choiceperiod == "week") {
	print $langs->trans("Week")." : ".$periodweek ." - ". $periodyear;
} else {
	print $langs->trans("Month")." : ".$periodmonth ." / ". $periodyearmonth;
}
print '</h2><br>';
print '</td><td align=right>';
print '<input type="button" class="butAction" id="planifyUser" value="'.$langs->trans("PlanifyUser").'">';
print '<input type="button" class="butActionDelete" id="cancel" value="'.$langs->trans("Cancel").'">';
print '</td></tr>';
print "</table>";

print "<div id='calendar' ></div>";

print '</form>';

//print '<br>';
print "<script>";
print "document.addEventListener('DOMContentLoaded', function() {"."\n";
print "var calendarEl = document.getElementById('calendar');"."\n";
print "var calendar = new FullCalendar.Calendar(calendarEl, {"."\n";

print "locale: 'fr',\n";
if ($choiceperiod == 'week')
	print "dayHeaderFormat: {weekday: 'long', day: '2-digit', month : '2-digit'},\n";
else
	print "dayHeaderFormat: {weekday: 'long'},\n";
print "timeZone: 'UTC',\n";
print "editable: false,\n";
print "themeSystem: 'standard',\n";
print "droppable: false,\n";
print "fixedWeekCount: false,\n";

$startHourDay=convertSecondToTime($conf->global->MYSCHEDULE_startHourDay?$conf->global->MYSCHEDULE_startHourDay:2*3600, "allhourmin", 86400);
$endHourDay=convertSecondToTime($conf->global->MYSCHEDULE_endHourDay?$conf->global->MYSCHEDULE_endHourDay:23*3600, "allhourmin", 86400);
$startHourWork=convertSecondToTime($conf->global->MYSCHEDULE_startHourWork?$conf->global->MYSCHEDULE_startHourWork:9*3600, "allhourmin", 86400);
$endHourWork=convertSecondToTime($conf->global->MYSCHEDULE_endHourWork?$conf->global->MYSCHEDULE_endHourWork:20*3600, "allhourmin", 86400);
print "slotMinTime: '".$startHourDay."',\n";
print "scrollTime: '".$startHourWork."',\n";
print "slotMaxTime: '".$endHourDay."',\n";
print "businessHours: {\n";
print "	daysOfWeek: [ 1, 2, 3, 4, 5 ],\n"; // Monday - Thursday
print "startTime: '".$startHourWork."',\n"; // a start time (10am in this example)
print "endTime: '".$endHourWork."',\n"; // an end time (6pm in this example)
print "},\n";

print "headerToolbar: {\n";
print "start: '',\n";
print "end: ''\n";
print "  },\n";

print "initialDate: '".$fullcalendarfirstday."',\n";
// selection du mode d'affichage de full calendar
switch($choiceperiod) {
	case "week":
		print "initialView: 'timeGridWeek',\n";
		print "allDaySlot: false,\n";
		break;
	case "month":
		print "initialView: 'dayGridMonth',"."\n";
		print "weekNumbers: true,\n";
		break;
}

// popup d'ouverture en modif, bon c'est pas du léger
print "eventClick: function(info) {},\n";

	
	
// mise en forme de l'élement (surcharge) au chargement des events
print "eventDidMount: function (info) {\n";
	print "info.el.querySelector('.fc-event-title').innerHTML = info.event.extendedProps.htmltitle;\n";
	print "info.el.querySelector('div.fc-event-time').setAttribute('style','display:none;'); \n";
	// on ajoute la durée en bout de ligne
	if( $choiceperiod == "week") {
		// on ajoute l'id de l'élement pour le récupérer plus tard
		print "info.el.querySelector('div.fc-event-main-frame').setAttribute('id', info.event.id);\n";
		print "info.el.querySelector('.fc-event-main').title = info.event.extendedProps.description;\n";
	} else {
		print "info.el.querySelector('div.fc-daygrid-event-dot').setAttribute('style','display:none;');\n";
		// on ajoute l'id de l'élement pour le récupérer plus tard
		print "info.el.querySelector('div.fc-daygrid-event-dot').setAttribute('id', info.event.id);\n";
		print "var curElem = info.el.querySelectorAll('div.fc-event-title');\n";
		print "curElem[0].setAttribute('style', 'background-color:'+info.event.backgroundColor);\n";
	}
	// on alimente le input avec les valeurs
print "},\n";

// sur le  click sur le numéro de la semaine de la vue mois, 
// affecte tout les temps de la période
print "navLinks: true,\n";
print " navLinkWeekClick: function(weekStart, jsEvent) {\n";
print " var dateOfWeek= new Date(weekStart);\n";

//     on boucle sur les jours de la semaine
print "for (i=0;i<7;i++) {\n";
//         on boucle sur les éléments
print "    calendar.getEvents().forEach(function(item){ \n";
print "        if (item.startStr.substring(0,10) == dateOfWeek.toISOString().substring(0,10)) {\n";
print "	           curElem = $('div#'+item.id+'.fc-daygrid-event-dot').parent();\n";
print "            curElem.find('div.fc-event-title').css('background-color','#".$conf->global->MYSCHEDULE_colormade."');\n";
print "	           curElem.find('.AutoFillTimeMade').click();\n";
print "        }\n";
print "    })\n";
//             on passe au jour suivant
print "        dateOfWeek.setDate(dateOfWeek.getDate() + 1);\n";
print " }},\n";

print " navLinkDayClick: function(date, jsEvent) {\n";
print " var dateday = date.toISOString();\n";
print " calendar.getEvents().forEach(function(item){ \n";
print "    if (item.startStr.substring(0,10) == dateday.substring(0,10)) {\n";
// si c'est un évènement du jour
if( $choiceperiod == "week") {
	//             on sélectionne le rendu de l'évent par son id (ajouté dans le render...)
	print "	       curElem = $('div#'+item.id+'.fc-event-main-frame');\n";
	print "        curElem.parent().parent().css('background-color','#".$conf->global->MYSCHEDULE_colormade."');\n";
} else {
	print "	       curElem = $('div#'+item.id+'.fc-daygrid-event-dot').parent();\n";
	print "        curElem.find('div.fc-event-title').css('background-color','#".$conf->global->MYSCHEDULE_colormade."');\n";
}
print "	       curElem.find('.AutoFillTimeMade').click();\n";

print "    }\n";
print "})},\n";

$editPlanned=false;
$editMade=true;

// on charge la liste des évènements
include 'events-load.inc.php'; // Must be include, not include_once

print "visibleRange: {\n";
print "    start: '".$fullcalendarfirstday."',\n";
print "    end: '".$fullcalendarlastday."'\n";
print "  },\n";
print "});"."\n";

print "calendar.render();"."\n";
// pour avoir l'agenda en blanc
print '$(".fc-daygrid").css("background", "white");';
print '$(".fc-timegrid").css("background", "white");';


print '$(".infobox-contrat").on("click touchstart", function(){';
	print 'curElem = $(this).parent().parent().parent().parent().parent().parent().parent();';
	if( $choiceperiod == "week") {
		print "        curElem.parent().parent().css('background-color','#".$conf->global->MYSCHEDULE_colormade."');\n";
	} else {
		print "        curElem.find('div.fc-event-title').css('background-color','#".$conf->global->MYSCHEDULE_colormade."');\n";
	}
	print "	       curElem.find('.AutoFillTimeMade').click();\n";	
print '});';

// fonction d'affectation des temps de planification (la petite fleche)
print '$(".AutoFillTime").on("click touchstart", function(){
	// mise a jour de la zone
	inter_user_id = $(this).data("rowname").split("-");
	dureehourmin=$(this).data("value");

	// on change le contenue du tableau
	fichinterdet_id = inter_user_id[0];
	user_id = inter_user_id[1];
	info = calendar.getEventById(fichinterdet_id);

	userArray = info.extendedProps.userArray;
	$.each(userArray, function(id, objuser) {;
		// si bon user 
		if (id == user_id)  {
			objuser["planned"]=dureehourmin;
			dureeUser = dureehourmin.split(":");
			objuser["plannedhour"]=parseInt(dureeUser[0]);
			objuser["plannedmin"]=parseInt(dureeUser[1]);

			$("div[name="+fichinterdet_id+"-"+user_id+"]").html(dureehourmin).trigger("change");
		}
	});

	// mise a jour du tableau des users modifié
	info.setExtendedProp( "userArray", userArray );
});';

print '$(".AutoFillTimeMade").on("click touchstart", function(){
	// mise a jour de la zone
	inter_user_id = $(this).data("rowname").split("-");
	dureehourmin=$(this).data("value");

	// on change le contenue du tableau
	fichinterdet_id = inter_user_id[0];
	user_id = inter_user_id[1];
	info = calendar.getEventById(fichinterdet_id);

	userArray = info.extendedProps.userArray;
	$.each(userArray, function(id, objuser) {;
		// si bon user 
		if (id == user_id)  {
			objuser["made"]=dureehourmin;
			dureeUser = dureehourmin.split(":");
			objuser["madehour"]=parseInt(dureeUser[0]);
			objuser["mademin"]=parseInt(dureeUser[1]);

			$("div[name=made-"+fichinterdet_id+"-"+user_id+"]").html(dureehourmin).trigger("change");
		}
	});

	// mise a jour du tableau des users modifié
	info.setExtendedProp( "userArray", userArray );
});';



// ouverture du popup de modif avancé
print '$(".openDialog").on("click touchstart", function(){';
print "fichinterdet_id = $(this).data('rowname');\n";
print "info = calendar.getEventById(fichinterdet_id);\n";
//  on alimente la popup avec les info de l'évent
print '$( "#dialog-editfichinter" ).dialog({';
	print 'modal: true,';
	print "width: 750,\n";
	print "height: 500,\n";
	print '	buttons: ['."\n";

	// entregistrement de l'inter 
	print '{	
		text: "'.$langs->transnoentities("Save").'",
		icons: { primary: "ui-icon-check" },
		click: function() { 

			userArray = info.extendedProps.userArray;
			$.each(userArray, function(id, objuser) {;
				// on met à jour ce qui a été saisie 
				for(i=1 ; i <= 4 ; i++) {
					// si bon user 
					if ($("#userid-"+i).val() == id) {
						dureehourmin= $("#select_planned-"+i+"hour").val();
						if (dureehourmin<10) dureehourmin= "0"+dureehourmin; 
						dureemin = $("#select_planned-"+i+"min").val();
						if (dureemin<10) dureemin= "0"+dureemin; 
						dureehourmin= dureehourmin+":"+dureemin;
						objuser["planned"]=dureehourmin;
						objuser["plannedhour"]=$("#select_planned-"+i+"hour").val();
						objuser["plannedmin"]=$("#select_planned-"+i+"min").val();
						// et le champs au niveau de levent
						$("div[name="+fichinterdet_id+"-"+id+"]").html(dureehourmin).trigger("change");

						dureehourmin= $("#select_made-"+i+"hour").val();
						if (dureehourmin<10) dureehourmin= "0"+dureehourmin; 
						dureemin = $("#select_made-"+i+"min").val();
						if (dureemin<10) dureemin= "0"+dureemin; 
						dureehourmin= dureehourmin +":"+dureemin;
						objuser["made"]=dureehourmin;
						objuser["madehour"]=$("#select_made-"+i+"hour").val();
						objuser["mademin"]=$("#select_made-"+i+"min").val();
						// et le champs au niveau de levent
						$("div[name=made-"+fichinterdet_id+"-"+id+"]").html(dureehourmin).trigger("change");



					}
				}
			});
			// mise a jour du tableau des users modifié
			info.setExtendedProp( "userArray", userArray );

			// ferme la fenetre
			$( this ).dialog( "close" );'."\n";
	print '}}'."\n";
	print '],'."\n";

	// on alimente les données de l'inter
	print "open : function() {\n";
	print "iee = info.extendedProps;\n";
	// on mémorise l'id de l'inter et celui de la ligne de détail 
	print '$("#fk_fichinter").val(iee.fk_fichinter)'.";\n";
	print '$("#fk_fichinterdet").val(info.id)'.";\n";

	print "title='".$langs->transnoentities("EditFichinter")." '+iee.ref;\n";
	print 'title = title + " " + iee.lib_statut'."\n";

	print 'if(info.backgroundColor == "#'.$conf->global->MYSCHEDULE_colornouser.'")'."\n";
	print '    title = title + " - '.$langs->trans("NoUserAffected").'"'."\n";

	print 'if(info.backgroundColor == "#'.$conf->global->MYSCHEDULE_colornotmade.'")'."\n";
	print '    title = title + " - '.$langs->trans("NotYetMade").'"'."\n";

	print 'if(info.backgroundColor == "#'.$conf->global->MYSCHEDULE_colornotplanned.'")'."\n";
	print '    title = title + " - '.$langs->trans("NotYetPlanned").'"'."\n";

	print 'if(info.backgroundColor == "#'.$conf->global->MYSCHEDULE_colormade.'")'."\n";
	print '    title = title + " - '.$langs->trans("Made").'"'."\n";

	print '$(".ui-dialog-title").html(title)'.";\n";
	print '$(".ui-dialog-titlebar").css("background", info.backgroundColor)'.";\n";

	print "$('#infoThirdParty').html(iee.lib_soc);\n";
	print "$('#infoDescriptionInter').html(iee.fi_description);\n";
	print "$('#infoDescrLigneDet').html(iee.description);\n";
	if ($conf->projet->enabled)
		print "$('#infoProject').html(iee.lib_projet);\n";

	if ($conf->contrat->enabled)
		print "$('#infoContract').html(iee.lib_contrat);\n";
	

	// alimentation de la date de début de l'inter et sa durée
	print "$('#infoDateStart').html(iee.datestart);\n";
	print "$('#infoDuration').html(iee.dureehourmin);\n";
	// boucle sur les utilisateur associé à l'intervention
	print 'for(i=1 ; i <= 4 ; i++) {'."\n";
	// on affiche tout les users
	print "    $('#box-user-'+i).hide();\n";
	print "}\n";
	print "i=0;\n";

	print "userArray = iee.userArray;\n";

	print "if (userArray != null) {\n";
	// on vide la zone pour la remplir ensuite
	print "$('#userlist').val('')\n";	
	print "$.each(userArray, function(id, objuser) {\n";
		print "    i=i+1;\n";
		//print "$('#userlist').val($('#userlist').val()+id+',')\n";	
		print "    $('#userid-'+i).val(id);\n";
		print "    $('#box-user-'+i).show();\n";
		// on change le nom 
		print "    $('#username-'+i).html(objuser.name);\n";
		// selon ce qui a été plannifié
		print "    $('#select_planned-'+i+'hour').val(objuser.plannedhour);\n";
		print "    $('#select_planned-'+i+'hour').trigger('change');\n";
		print "    $('#select_planned-'+i+'min').val(objuser.plannedmin);\n";
		print "    $('#select_planned-'+i+'min').trigger('change');\n";
		// selon ce qui a été déjà fait
		print "    $('#select_made-'+i+'hour').val(objuser.madehour);\n";
		print "    $('#select_made-'+i+'hour').trigger('change');\n";
		print "    $('#select_made-'+i+'min').val(objuser.mademin);\n";
		print "    $('#select_made-'+i+'min').trigger('change');\n";

		// selon le temps saisie on change la couleur
		print "if (objuser.plannedhour+objuser.plannedmin+objuser.madehour+objuser.mademin==0) {\n";
		print "    $('#info-box-content-'+i).css('background-color', '#".$conf->global->MYSCHEDULE_colornotplanned."');\n";
		print "    $('#box-icon-'+i).css('color', '#".$conf->global->MYSCHEDULE_colornotplanned."');\n";
		print "} else if (objuser.plannedhour+objuser.plannedmin>0 && objuser.madehour+objuser.mademin==0) {\n";
		print "    $('#info-box-content-'+i).css('background-color', '#".$conf->global->MYSCHEDULE_colornotmade."');\n";
		print "    $('#box-icon-'+i).css('color', '#".$conf->global->MYSCHEDULE_colornotmade."');\n";
		print "} else if (objuser.plannedhour+objuser.plannedmin>0 && objuser.madehour+objuser.mademin>0) {\n";
		print "    $('#info-box-content-'+i).css('background-color', '#".$conf->global->MYSCHEDULE_colormade."');\n";
		print "    $('#box-icon-'+i).css('color', '#".$conf->global->MYSCHEDULE_colormade."');\n";
		print "}\n";
	print "})};\n";
	
	// on cache les autres box
	print 'for(j=i+1 ; j <= 4 ; j++) {'."\n";
	// on cache les éléments sans user
	print "    $('#box-user-'+j).hide();\n";
	print "}\n";

	print "}\n";
	print '});';
print "});\n";
	

/// Gestion des boutons, doit être faite ici pour acéder aux évents
print "$('#planifyUser').click( function() {\n"; 	// lancement de la suppression des évents
	// on boucle sur les évents
	print "calendar.getEvents().forEach(function(item){\n";

	// on boucle sur tous les utilisateurs
	print "userArray = item.extendedProps.userArray;\n";

	print "$.each(userArray, function(id, objuser) {\n";
		print "durationplanned=(objuser['plannedhour']*3600)+(objuser['plannedmin']*60);\n";
		print "durationmade=(objuser['madehour']*3600)+(objuser['mademin']*60);\n";

		print "console.log(durationplanned);\n";
		// on transmet l'inter, la ligne de détail, l'user et le temps plannifiée
		print "        $.ajax({ async: false, type: 'GET',";
		print "    url:'".dol_buildpath("/myschedule/fichinter/ajax/", 1);
		print "event-jobmadeuser.php?userid='+id+'&fk_fichinterdet='+item.id";
		print "+'&durationplanned='+durationplanned";
		print "+'&durationmade='+durationmade";
		print "});\n";
	print "});\n";
	// en param le temps affecté à l'user
	print "});\n";

	print "$('#cancel').trigger('click');\n";
print "});\n";

print "});"."\n";

// le cancel n'a pas besoin d'etre dans la déclaration du calendar
print "$('#cancel').click( function() {\n";
	print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
	print "fullcalendar.php?choiceperiod=".$choiceperiod;
	print "&periodyear=".$periodyear;
	print "&periodweek=".$periodweek;
	print "&periodmonth=".$periodmonth;
	print $urlPeriodFilter."', '_self');\n";
print "})\n";

print "</script>";
print '</div>'."\n";

// dialog de la modif d'inter
// ------------------------
print '<div id="dialog-editfichinter" style="padding:0;" class="hideobject" title="REFandStatut">'."\n";
print '<form id="editfichinter" name="editfichinter" action="massplanification.php" method="post">';
print '<input type="hidden" name="token" value="' . $_SESSION ['newtoken'] . '">';
print '<input type="hidden" name="action" value="editfichinter" >';
// récupération des informations de l'interface
print '<input type="hidden" name="choiceperiod" value="'.$choiceperiod.'">';
print '<input type="hidden" name="firstdayweek" value="'.$firstdayweek.'">';
print '<input type="hidden" name="statutinter" value="'.$statutinter.'">';
print '<input type="hidden" name="perioduser" value="'.$perioduser.'">';
print '<input type="hidden" name="periodsoc" value="'.$periodsoc.'">';
print '<input type="hidden" name="dolstatut" value="'.$dolstatut.'">';

// les données sont mise à jour lors du click
print '<input type="hidden" id="fk_fichinterdet" name="fk_fichinterdet" value="">';
print '<input type="hidden" id="fk_fichinter" name="fk_fichinter" value="">';


//print '';
print '<table class="noborder" style="width:100%" >';
print "<tr><td width=20%>".$langs->trans("ThirdParty")."</td><td>";
print '<div id=infoThirdParty>ThirdParty</div>';
print "</td></tr>";
// ca risque d'etre chaud
if ($conf->contrat->enabled) {
	$langs->load("Contracts");
	print '<tr><td>'.$langs->trans("Contract").'</td><td>';
	print '<div id=infoContract>CONTRAT</div>';
	print '</td></tr>';
}
if ($conf->projet->enabled) {
	$langs->load("projets");
	print '<tr><td>'.$langs->trans("Project").'</td><td>';
	print '<div id=infoProject>Project</div>';
	print '</td></tr>';
}

print "<tr><td colspan=2>";
print "<div id=infoDescriptionInter>Description intervention</div>";
print "</td></tr>";

print '</table>';

print '<table class="noborder" >';

print "<tr>";
print "<td rowspan=2 valign=top>";
print "<div id=infoDescrLigneDet>Description Ligne Det</div>";
print "</td>";
print '<td width=15%>'.$langs->trans('DateStart').'</td>';
print '<td width=10% valign=top>';
print "<div id=infoDateStart>DD/MM/YYYY</div>";
print '</td>';
print '</tr>';
print '<tr><td>'.$langs->trans('Duration').'</td>';
print '<td align=left valign=top>';
print "<div id=infoDuration>HH:MM</div>";
print '</td>';
print '</tr>';
print '</table>';
// ensuite les utilisateurs
print '<div class="box-flex-container" style="width:750px;margin-left:0px;margin-right:0px;">';
// boucle sur les zone des collaborateurs
for ($i=1;$i<=4;$i++) {
	print '<div class="box-flex-item info-box-module" id="box-user-'.$i.'">';
	print '<div class="info-box info-box-sm info-box-module" ><div class="info-box-icon" >';
	print '<span id="box-icon-'.$i.'" class="fas fa-user inline-block valignmiddle"></span>';
	//print '<span class="info-box-icon-version" style="text-align:left;color:red" >';
	//print "<input type=checkbox name='chkDelUser-'.$i.' value=1> ".$langs->trans('DelUser');
	//print '</span>';
	print '</div>';
	print '<div id="info-box-content-'.$i.'" class="info-box-content info-box-text-module">';
	print '<span class="info-box-title" id="username-'.$i.'">USER</span>';
	print '<input type=hidden name="userid-'.$i.'" id="userid-'.$i.'" value="">';
	print '<table class="noborder" >';
	print '<tr><td style="padding:3px">'.$langs->trans('Planned').'</td>';
	print '<td style="padding:3px" align=left>';
	$form->select_duration('planned-'.$i, 3600, 0, 'select', 0);
	print '</td></tr>';

	print '<tr><td style="padding:3px">'.$langs->trans('Made').'</td>';
	print '<td style="padding:3px" align=left>';
	$form->select_duration('made-'.$i, 3600, 0, 'select', 0);
	print '</td></tr>';

	print "</table>";
	print '</div>'; 
	print '</div></div>';
}
print '</form>';
print '</div>'; // flex-container
print '</div>'; // dialog



// End of page
llxFooter();
$db->close();