<?php
/* Copyright (C) 2013-2018	Charlene BENKE	<charlie@patas-monkey.com>
*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file	   	htdocs/myschedule/tabs/intervention.php
 *	\ingroup		myschedule
 *	\brief	  	Page of fichinter myschedule
 */

$res=0;
if (! $res && file_exists("../../main.inc.php")) 
	$res=@include("../../main.inc.php");		// For root directory
if (! $res && file_exists("../../../main.inc.php")) 
	$res=@include("../../../main.inc.php");	// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';

require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT.'/projet/class/task.class.php';

require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';


dol_include_once('/myschedule/class/myschedule.class.php');

$langs->load('companies');
$langs->load('interventions');
$langs->load('bills');
$langs->load('myschedule@myschedule');

//$langs->load(' ');
//$langs->load('compta');
//$langs->load('bills');
//$langs->load('orders');
$langs->load('products');
if (! empty($conf->margin->enabled))
	$langs->load('margins');

$error=0;

$id 	= GETPOST('id', 'int');
$ref 	= GETPOST('ref', 'alpha');
$action	= GETPOST('action', 'alpha');
$choiceperiod= GETPOST('choiceperiod', 'alpha');

// si non renseign on prend le par dfaut
if (!$choiceperiod)
	$choiceperiod= "week";

$filterbystatut=GETPOST('filterbystatut', 'int');

$periodday=GETPOST('day', 'alpha');
if (!$periodday)
	$periodday = dol_mktime(0, 0, 0, date('m'), date('d'), date('Y'));
else
	$periodday = dol_mktime(
				0, 0, 0,
				GETPOST('daymonth', 'int'),
				GETPOST('dayday', 'int'),
				GETPOST('dayyear', 'int')
);	


$periodyear=GETPOST('periodyear', 'int');
if (!$periodyear)
	$periodyear=date('Y');

$periodyearmonth=GETPOST('periodyearmonth', 'int');
if (!$periodyearmonth)
	$periodyearmonth=date('Y');

$periodmonth=GETPOST('periodmonth', 'int');
if (! $periodmonth )
	$periodmonth=date('m');

$periodweek=GETPOST('periodweek', 'int');
if (!$periodweek)
	$periodweek=date('W');

if ($choiceperiod=='week') {

	$timeStampPremierJanvier = strtotime($periodyear . '-01-01');
	$jourPremierJanvier = date('w', $timeStampPremierJanvier);

	//-- recherche du N de semaine du 1er janvier -------------------
	$numSemainePremierJanvier = date('W', $timeStampPremierJanvier);

	//-- nombre  ajouter en fonction du numro prcdent ------------
	$decallage = ($numSemainePremierJanvier == 1) ? $periodweek - 1 : $periodweek;
	//-- timestamp du jour dans la semaine recherche ----------------
	$timeStampDate = strtotime('+' . $decallage . ' weeks', $timeStampPremierJanvier);
	//-- recherche du lundi de la semaine en fonction de la ligne prcdente ---------
	$firstdayweek = ($jourPremierJanvier == 1) ?  $timeStampDate : strtotime('last monday', $timeStampDate);
	$lastdayweek = strtotime(date("Y-m-d", strtotime(date('d-m-Y', $firstdayweek)))." +6 day"); 

	$fullcalendarfirstday=date("Y-m-d", $firstdayweek);
	$fullcalendarlastday=date("Y-m-d", $lastdayweek);
} 
if ($choiceperiod=='day') {
	$fullcalendarfirstday=date("Y-m-d", $periodday);
	$fullcalendarlastday=date("Y-m-d", $periodday);
} 
if ($choiceperiod=='month') {
	$fullcalendarfirstday=date("Y-m-d", dol_mktime(0, 0, 0, $periodmonth, 1, $periodyearmonth));
	$fullcalendarlastday=date("Y-m-d", dol_mktime(0, 0, 0, $periodmonth, 30, $periodyearmonth));
} 



$perioduser=GETPOST('perioduser', 'int');
if (!$perioduser && $user->admin == 0)
	$perioduser=$user->id;

$periodsoc=GETPOST('periodsoc', 'int');
if ($periodsoc ==0 && ! empty($user->societe_id))
	$periodsoc = $user->societe_id;



// Security check
if (! empty($user->societe_id))
	$socid=$user->societe_id;
$result = restrictedArea($user, 'ficheinter', $id, 'fichinter');



/*
 * View
 */
$arrayofcss = array
	( '/myschedule/css/fullcalendar.min.css'
	);

$arrayofjs = array
	( '/myschedule/js/lib/moment.min.js'
	, '/myschedule/js/fullcalendar.min.js'
	, '/myschedule/js/locale/fr.js'
);

llxHeader('', "", "", '', 0, 0, $arrayofjs, $arrayofcss, '');


$form = new Form($db);
$formother = new FormOther($db);
$formfile = new FormFile($db);
$companystatic=new Societe($db);



$now=dol_now();

/*
 * Show object in view mode
 */
$title=$langs->trans("TaskPlanned");

print_fiche_titre($title, "", 'title_agenda');

print '<form method="POST" action="fullcalendar.php">';
print '<table class="noborder" >';
print '<tr class="liste_titre">';
print '<th align=left width=250px>'.$langs->trans("Period").'</th>';
print '<th  align=left >'.$langs->trans("Filters").'</th>';
print '<th  align=left width=250px>';
print '</th>';
print "</tr>\n";

print '<tr >';
print '<td >';
print '<table>';
print '<tr><td><input type=radio name=choiceperiod '.($choiceperiod=="day"?"checked":"").' value="day"></td><td>';
print $form->select_date($periodday, 'day', 0, 0, '', "day", 1, 1, 1);
print '</td></tr>';
print '<tr><td><input type=radio '.($choiceperiod=="week"?"checked":"").' name=choiceperiod value="week"></td><td>';
print $formother->selectyear($periodyear, 'periodyear');
print select_week($periodweek, 'periodweek');
print '</td></tr>';
print '<tr><td><input type=radio '.($choiceperiod=="month"?"checked":"").' name=choiceperiod value="month"></td><td>';
print $formother->selectyear($periodyearmonth, 'periodyearmonth');
print $formother->select_month($periodmonth, 'periodmonth');
print '</td></tr>';
print '</table>';
print '</td>';

$showempty=1;
$filteruser="";
if ($user->admin == 0)
	$filteruser=" AND (u.rowid = ".$user->id." OR fk_user=".$user->id.")";

print '<td valign=top>'.$form->select_dolusers(
				$perioduser, 'perioduser', $showempty,
				'', 0, '', '', 0, 0, 0, $filteruser
);
print "<br>";


$showempty=1;
print $form->select_company($periodsoc, 'periodsoc', '', $showempty).'</td>';
print '<td valign=top>';
$statutArray = array(
				'0'=>$langs->trans('SeeAll'), 
				'1'=>$langs->trans('SeeOnlyNotAffected'),
				'2'=>$langs->trans('SeeOnlyNotPlanned'),
				'3'=>$langs->trans('SeeOnlyNotMade'),
				'4'=>$langs->trans('SeeOnlyMade'),
);
print $form->selectarray('filterbystatut', $statutArray, $filterbystatut);
print '<br><input type=submit class="button" name="select" value="'.$langs->trans("Select").'">';

print "</td></tr>\n";
print "</table>";
print '</form>';

//print "<div id='external-events'>";
//print "    <h4>Draggable Events</h4>";
//print "    <div class='fc-event'>New Event</div>";
//print "    <p>";
//print "      <img src='trash-can.png' id='trash' alt=''>";
//print "    </p>";
//print "</div>";

print "<div id='calendar'></div>";
print "<script>";
print "var zone = '01:00';\n";
print "var local = $.fullCalendar.moment('".$fullcalendarfirstday."');\n";
print "$('#calendar').fullCalendar({\n";
print "header: {\n";
print "left: '',\n";
print "center: 'title',\n";
print "right: ''\n";
print "  },\n";
print " navLinks: true,\n";
print " navLinkDayClick: function(dateday, jsEvent) {\n";
print "window.open('".dol_buildpath("/myschedule/projet/", 1);
print "fullcalendar.php?choiceperiod=day";
print "&day='+dateday.format('YYYY-MM-DD')+'";
print "&daymonth='+dateday.format('MM')+'";
print "&dayday='+dateday.format('DD')+'";
print "&dayyear='+dateday.format('YYYY')+'";
print "&filterbystatut=".$filterbystatut;
if ($periodsoc > 0)
	print "&periodsoc=".$periodsoc;
if ($perioduser > 0)
	print "&perioduser=".$perioduser."\n";
print "', '_blank');\n";

print "  },\n";
print " navLinkWeekClick: function(weekStart, jsEvent) {\n";
print " var weeknumber = weekStart.week();\n";
print "window.open('".dol_buildpath("/myschedule/projet/", 1);
print "fullcalendar.php?choiceperiod=week";
print "&periodweek='+weeknumber+'";
print "&periodyear=".$periodyear;
print "&filterbystatut=".$filterbystatut;
if ($periodsoc > 0)
	print "&periodsoc=".$periodsoc;
if ($perioduser > 0)
	print "&perioduser=".$perioduser."\n";
print "', '_blank');\n";
print "  },\n";

switch($choiceperiod) {
	case "week":
		print "defaultView: 'agendaWeek',\n";
		break;	
	case "month":
		print "defaultView: 'month',\n";
		print "weekNumbers: true,\n";
		break;	
	case "day":
		print "defaultView: 'agendaDay',\n";
		break;	
}
print "events: {\n";
print "url: '".dol_buildpath("/myschedule/projet/ajax/",1);
print "events-feed.php?datedeb=".$fullcalendarfirstday;
print "&datefin=".$fullcalendarlastday;
print "&filterbystatut=".$filterbystatut;
print "&periodsoc=".$periodsoc;
print "&perioduser=".$perioduser."',\n";
print "type: 'POST', // Send post data\n";
print "error: function() {\n";
print "alert('There was an error while fetching events.');\n";
print "}},\n";
print "visibleRange: {\n";
print "    start: '".$fullcalendarfirstday."',\n";
print "    end: '".$fullcalendarlastday."'\n";
print "  },\n";

print "editable: true,\n";
print "droppable: true\n";
print "});\n";
print "$('#calendar').fullCalendar( 'gotoDate', local );\n";

print "</script>";
/**
 *	  Return HTML combo list of week
 *
 *	  @param  string	  $selected		  Preselected value
 *	  @param  string	  $htmlname		  Name of HTML select object
 *	  @param  int		 $useempty		  Show empty in list
 *	  @param  int		 $longlabel		 Show long label
 *	  @return string
 */
function select_week($selected='', $htmlname='weekid', $useempty=0)
{
//	global $langs;

	require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
	$select_week = '<select class="flat" name="'.$htmlname.'" id="'.$htmlname.'">';
	if ($useempty)
		$select_week .= '<option value="0">&nbsp;</option>';

	for ( $week=1; $week < 54; $week++) {
		$selectedoption="";
		if ($selected == $week)
			$selectedoption=" selected ";
		$select_week .= '<option value="'.$week.'" '.$selectedoption.'>';
		$select_week .= $week;
		$select_week .= '</option>';
	}
	$select_week .= '</select>';
	return $select_week;
}

// End of page
llxFooter();
$db->close();