<?php
/* Copyright (C) 2012-2020		Charlene Benke		<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file	   custom/myschedule/tabs/societe.php
 *	\brief	  List of all interventionnal myscheduled
 *	\ingroup	mySchedule
 */

 $res=@include("../../main.inc.php");					// For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."/main.inc.php"))
	$res=@include($_SERVER['DOCUMENT_ROOT']."/main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../../main.inc.php");		// For "custom" directory

require_once(DOL_DOCUMENT_ROOT."/core/class/html.formfile.class.php");
require_once(DOL_DOCUMENT_ROOT."/core/lib/date.lib.php");

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/fichinter/class/fichinter.class.php';
require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/contact.lib.php';

dol_include_once('/myschedule/class/myschedule.class.php');
dol_include_once('/myschedule/core/lib/myschedule.lib.php');

$langs->load("companies");
$langs->load('interventions');
$langs->load("myschedule@myschedule");

// Security check
$id = GETPOST('id', 'int');
$ref = GETPOST('ref', 'alpha');

if ($user->societe_id) $socid=$user->societe_id;
$result = restrictedArea($user, 'myschedule');

$sortfield = GETPOST('sortfield', 'alpha');
$sortorder = GETPOST('sortorder', 'alpha');
$page = GETPOST('page')?GETPOST('page', 'int'):0;
$offset = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;

if (! $sortorder) $sortorder="DESC";
if (! $sortfield) $sortfield="ft.date";


$limit = $conf->liste_limit;

$choiceperiod= GETPOST('choiceperiod')?GETPOST('choiceperiod', 'alpha'):$conf->global->MYSCHEDULE_PeriodFilter;
$firstdayweek= GETPOST('firstdayweek')?strtotime( GETPOST('firstdayweek', 'alpha')):"";

$statutinter=GETPOST('statutinter')?GETPOST('statutinter', 'array'):explode(",","nouser,notmade,notplanned,made");

$perioduser=GETPOST('perioduser')?GETPOST('perioduser', 'int'):0;
if ($perioduser==0 && $user->admin == 0)
	$perioduser=$user->id;
$periodcontact=GETPOST('periodcontact')?GETPOST('periodcontact', 'int'):-1;

$dolstatut=GETPOST('dolstatut')?GETPOST('dolstatut', 'int'):-1;

$periodyear=GETPOST('periodyear', 'int');
if (!$periodyear)
	$periodyear=date('Y');

$periodyearmonth=GETPOST('periodyearmonth', 'int');
if (!$periodyearmonth)
	$periodyearmonth=date('Y');

$periodmonth=GETPOST('periodmonth', 'int');
if (! $periodmonth )
	$periodmonth=date('m');

$periodweek=GETPOST('periodweek', 'int');
if (!$periodweek)
	$periodweek=date('W');

if ($choiceperiod == 'week') {
	if ($firstdayweek == "") 
		$firstdayweek = firstdayweek($periodweek, $periodyear);
	else
		$periodweek = date("W", $firstdayweek);

	$periodmonth=date('m', $firstdayweek);
	$lastdayweek = strtotime(date("Y-m-d", strtotime(date('d-m-Y', $firstdayweek)))." +6 day"); 

	$fullcalendarfirstday=date("Y-m-d", $firstdayweek);
	$fullcalendarlastday=date("Y-m-d", $lastdayweek);	

	$fullcalendarfirstday = date("Y-m-d", $firstdayweek);
} 
if ($choiceperiod=='month') {
	$fullcalendarfirstday=date("Y-m-d", dol_mktime(0, 0, 0, $periodmonth, 1, $periodyearmonth));
	$fullcalendarlastday=date("Y-m-d", dol_mktime(0, 0, 0, $periodmonth, 30, $periodyearmonth));
} 


$form = new Form($db);
$formother = new FormOther($db);


$title=$langs->trans("ThirdParty").' - '.$langs->trans("mySchedule");
$help_url='EN:Module_mySchedule|FR:Module_mySchedule|ES:Modulo_mySchedule';

llxHeader('', $title, $help_url);

$object = new Contact($db);
$object->fetch($id, $ref);

$head = contact_prepare_head($object);

dol_fiche_head($head, 'myschedule', $langs->trans("Contact"), 0, 'contact');


$morehtmlref = '<div class="refidno">';
if (empty($conf->global->SOCIETE_DISABLE_CONTACTS))
{
	$objsoc = new Societe($db);
	$objsoc->fetch($object->socid);
	// Thirdparty
	$morehtmlref .= $langs->trans('ThirdParty').' : ';
	if ($objsoc->id > 0) $morehtmlref .= $objsoc->getNomUrl(1);
	else $morehtmlref .= $langs->trans("ContactNotLinkedToCompany");
}
$morehtmlref .= '</div>';

$linkback = '<a href="'.DOL_URL_ROOT.'/contact/list.php">'.$langs->trans("BackToList").'</a>';

$urlPeriodFilter = "&filterbystatut=".implode(",", $statutinter);
$urlPeriodFilter.= "&choiceperiod=".$choiceperiod;
$urlPeriodFilter.= "&periodyear=".$periodyear;
$urlPeriodFilter.= "&periodyearmonth=".$periodyearmonth;
$urlPeriodFilter.= "&periodmonth=".$periodmonth;
$urlPeriodFilter.= "&periodweek=".$periodweek;
$urlPeriodFilter.= "&dolstatut=".$dolstatut;
if ($periodsoc > 0)
	$urlPeriodFilter.= "&periodsoc=".$periodsoc;
if ($perioduser > 0)
	$urlPeriodFilter.= "&perioduser=".$perioduser;
if ($periodcontact > 0)
	$urlPeriodFilter.= "&periodcontact=".$periodcontact;

dol_banner_tab($object, 'id', $linkback, 1, 'rowid', 'ref', $morehtmlref, $urlPeriodFilter);

$cssclass='titlefield';

print '<div class="fichecenter">';

print '<div class="underbanner clearboth"></div>';
print '<table class="border centpercent">';

if (! empty($conf->global->SOCIETE_USEPREFIX)) {
	// Old not used prefix field
	print '<tr><td class="'.$cssclass.'">'.$langs->trans('Prefix').'</td>';
	print '<td colspan="3">'.$object->prefix_comm.'</td></tr>';
}

if ($object->client) {
	print '<tr><td class="'.$cssclass.'">';
	print $langs->trans('CustomerCode').'</td><td colspan="3">';
	print $object->code_client;
	if ($object->check_codeclient() <> 0) 
		print ' <font class="error">('.$langs->trans("WrongCustomerCode").')</font>';
	print '</td></tr>';
}

if ($object->fournisseur) {
	print '<tr><td class="'.$cssclass.'">';
	print $langs->trans('SupplierCode').'</td><td colspan="3">';
	print $object->code_fournisseur;
	if ($object->check_codefournisseur() <> 0) 
		print ' <font class="error">('.$langs->trans("WrongSupplierCode").')</font>';
	print '</td></tr>';
}

print "</table>";
print '</div>';
dol_fiche_end();
/*
 * Show object in view mode
 */
print load_fiche_titre($title, "", 'myschedule@myschedule');
$showempty=1;

print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<table class="noborder" >';
print '<tr class="liste_titre">';
print '<th align=left colspan=4 >'.$langs->trans("Filters").'</th>';
print "</tr>\n";

print '<tr >';
print '<td valign=top>';
print '<table>';
print '<tr><td><input type=radio '.($choiceperiod=="week"?"checked":"").' name=choiceperiod value="week"></td><td>';
print $formother->selectyear($periodyear, 'periodyear');
print select_week($periodweek, 'periodweek');
print '</td></tr>';
print '<tr><td><input type=radio '.($choiceperiod=="month"?"checked":"").' name=choiceperiod value="month"></td><td>';
print $formother->selectyear($periodyearmonth, 'periodyearmonth');
print $formother->select_month($periodmonth, 'periodmonth', 0, 1, "");
print '</td></tr>';

print "<tr><td>".$langs->trans("Status")."</td><td>";
$statutArray = array(
	'0'=>$langs->trans('Draft'), 
	'1'=>$langs->trans('Validate'),
	'2'=>$langs->trans('StatusInterInvoiced'),
	'3'=>$langs->trans('Closed')
);
print $form->selectarray('dolstatut', $statutArray, $dolstatut, $showempty );
print "</td></tr>";

print '</table>';
print '</td>';

// filtre sur la société

print '<td valign=top>';
print '<input type=hidden name="id" value="'.$id.'">';
$periodcontact=$id;
print '<table>';
// on ne voit que ses intervention ou celle des collabs dont on est le suppérieur
$filteruser="";
if ($user->admin == 0)
	$filteruser=" AND (u.rowid = ".$user->id." OR fk_user=".$user->id.")";
print '<tr><td>'.$langs->trans("Users")."</td><td>"; 
print $form->select_dolusers(
			$perioduser, 'perioduser', $showempty,
			'', 0, '', '', 0, 0, 0, $filteruser
);
print "</td></tr>";

print "<tr><td>".$langs->trans("ThirdParty")."</td><td>";
print $form->select_company($socid, 'periodsoc', '', $showempty);
print "</td></tr>";

$showFonction=0;
$showSoc=1;
print '<tr><td>'.$langs->trans("Contact")."</td><td>"; 
print $form->selectcontacts(0, $periodcontact, 'periodcontact', 
			$showempty, '', '',  $showFonction, '',  false, $showsoc ,  0, array(), ' disabled'
);
print "</td></tr>";

print '</table>';
print '</td>';

print '<td valign=top align=right>';
print '<table width=100%>';
print '<tr><td bgcolor="'.$conf->global->MYSCHEDULE_colornouser.'" title="'.$langs->trans("InfoNoUserAffected").'">';
print '<input name="statutinter[]" value="nouser"  '.(in_array("nouser", $statutinter)?" checked ":0).' type=checkbox>';
print $langs->trans("NoUserAffected")."</td>\n";
print '<td bgcolor="'.$conf->global->MYSCHEDULE_colornotmade.'" title="'.$langs->trans("InfoNotYetMade").'">';
print '<input name="statutinter[]" value="notmade"  '.(in_array("notmade", $statutinter)?" checked ":0).' type=checkbox>';
print $langs->trans("NotYetMade")."</td></tr>\n";
print '<tr><td bgcolor="'.$conf->global->MYSCHEDULE_colornotplanned.'" title="'.$langs->trans("InfoNotYetPlanned").'">';
print '<input name="statutinter[]" value="notplanned" '.(in_array("notplanned", $statutinter)?" checked ":0).' type=checkbox>';
print $langs->trans("NotYetPlanned")."</td>\n";
print '<td bgcolor="'.$conf->global->MYSCHEDULE_colormade.'" title="'.$langs->trans("InfoMade").'">';
print '<input name="statutinter[]" value="made" '.(in_array("made", $statutinter)?" checked ":0).' type=checkbox>';
print  $langs->trans("Made")."</td></tr>\n";
print "</table>";
print '<br><input type=submit class="button" name="select" value="'.$langs->trans("Search").'">';
print '</td>';
print '<td valign=bottom align=right>';

print "</td>";
print "</tr>\n";
print "</table>";
print '</form>';
print '<br>';

$sql = 'SELECT DISTINCT f.ref, f.description as descinter,ft.rowid, ft.fk_fichinter, ft.description, ft.duree, ft.rang,';
$sql.= ' ft.date as date_intervention, f.fk_statut';
$sql.= ' FROM '.MAIN_DB_PREFIX.'fichinterdet as ft, '.MAIN_DB_PREFIX.'fichinter as f';
$sql.= ' , '.MAIN_DB_PREFIX.'societe as s';
$sql.= ' , '.MAIN_DB_PREFIX.'element_contact as ec  , '.MAIN_DB_PREFIX.'c_type_contact as ctc';
$sql.= ' , '.MAIN_DB_PREFIX.'socpeople as sp ';
if ($perioduser > 0)
	$sql.= ' , '.MAIN_DB_PREFIX.'user as u ';
$sql.= ' WHERE date_format(ft.date, "%Y-%m-%d") >= "'.$fullcalendarfirstday.'"';
$sql.= ' AND date_format(ft.date, "%Y-%m-%d") <= "'.$fullcalendarlastday.'"';
$sql.= ' AND ft.fk_fichinter = f.rowid';
$sql.= ' AND f.fk_soc= s.rowid';
$sql.= ' AND ec.fk_socpeople = '.$id;

if ($dolstatut > 0) 
	$sql.= ' AND f.fk_statut = '.$dolstatut;

$sql.= ' AND f.rowid = ec.element_id AND ec.fk_c_type_contact = ctc.rowid';
$sql.= ' AND ctc.element="fichinter"';
if ($perioduser <= 0) {
	// pas de filtre sur les user, juste sur les contacts
	$sql.= ' AND source="external" AND ec.fk_socpeople = sp.rowid';
} else {
	// on filtre sur les deux à la fois
	$sql.= ' AND (( source="external" AND ec.fk_socpeople = sp.rowid)';
	$sql.= ' OR (source="internal" AND ec.fk_socpeople = u.rowid';
	$sql.= ' AND (u.rowid='.$perioduser.' OR u.fk_user='.$perioduser.')))';
}
if ($socid>0)
	$sql.= ' AND (f.fk_soc = '.$socid.' OR s.parent = '.$socid.")";

$sql.= " ORDER BY ".$sortfield." ".$sortorder;


$urlparam="&amp;id=".$id.$moreparam;

$resql = $db->query($sql);
if ($resql) {
	$num = $db->num_rows($resql);
	$j = 0;

	print '<table class="noborder">';
	print "<tr class='liste_titre'>";
	print_liste_field_titre(
					$langs->trans("Ref"), $_SERVER["PHP_SELF"], "f.ref", 
					"", $urlparam, 'width=10%', $sortfield, $sortorder
	);
	print_liste_field_titre(
		$langs->trans("DescrInter"), $_SERVER["PHP_SELF"], 'f.description', 
		"", $urlparam, '', $sortfield, $sortorder
	);

	print_liste_field_titre(
					$langs->trans("DateIntervention"), $_SERVER["PHP_SELF"], "ft.date", 
					"", $urlparam, 'width=100px', $sortfield, $sortorder
	);
	print_liste_field_titre(
					$langs->trans("Duration"), $_SERVER["PHP_SELF"], 'ft.duree', 
					"", $urlparam, 'align=right width=60px', $sortfield, $sortorder
	);
	print_liste_field_titre(
					$langs->trans("Description"), $_SERVER["PHP_SELF"], 'ft.description', 
					"", $urlparam, '', $sortfield, $sortorder
	);

	$contactWidth='';
	if ($conf->global->MYSCHEDULE_nbcontactonlist > 0)
		$contactWidth='width=15%';
	print_liste_field_titre(
		$langs->trans("AffectedUser"), $_SERVER["PHP_SELF"], "", 
		"", $urlparam, $contactWidth, $sortfield, $sortorder
	);
	print_liste_field_titre(
		$langs->trans("AffectedContact"), $_SERVER["PHP_SELF"], "", 
		"", $urlparam, $contactWidth, $sortfield, $sortorder
	);

	print_liste_field_titre(
					$langs->trans("Status"), $_SERVER["PHP_SELF"], "f.fk_statut", 
					"", $urlparam, 'width=80px align="right"', $sortfield, $sortorder
	);
	print "</tr>\n";


	$object = new Fichinter($db);
	$fichinterdet_schedule = new fichinterdet_schedule($db);
	$userstatic=new User($db);
	$contactstatic=new Contact($db);

	while ($j < $num) {
		$objp = $db->fetch_object($resql);
		$object->fetch($objp->fk_fichinter);
		$object->fetch_thirdparty();
		$tab = $object->liste_contact(-1, 'internal');
		$listUser="";

		// la gestion des utilisateur
		$nbUser = count($tab);
		if ($nbUser > 0) {

			$totalPlanned= 0;
			$totalMade= 0;
			$bshowelement=false;

			// champs contenant les ids des inter et contact ainsi que le temps associé
			foreach($tab as $userinter) {
				$ret = $userstatic->fetch($userinter['id']);
				$listUser.="<div  style='float:left;width:99%;'><div style='display: inline-block;'>".$userstatic->getnomUrl(1, "", 0, 1)."</div>";
				 //.' ('.$userinter['libelle'].')'."<br>";

				// on récupère ce qui a été saisie pour cet user/inter
				//$ret = $fichinterdet_schedule->fetch(0, $userinter['id'], $objp->rowid);
				$sql = 'SELECT rowid, fk_product, duration_planned, duration_made';
				$sql.= ' FROM '.MAIN_DB_PREFIX.'fichinterdet_schedule';
				$sql.= ' WHERE fk_fichinterdet = '.$objp->rowid;
				$sql.= ' AND fk_user = '.$userinter['id'];
				$reusersql = $db->query($sql);
				$planned = 0;
				$default = "";
				$made = 0;
				if ($reusersql) {
					$objuser = $db->fetch_object($reusersql);
					$planned = $objuser->duration_planned;
					$made = ($objuser->duration_made!=0?$objuser->duration_made:0);

					$listUser.=" (".convertSecondToTime($planned, "allhourmin", 86400);
					if ($made)
						$listUser.='/'.convertSecondToTime($made, "allhourmin", 86400);
					$listUser.=')';
					$totalPlanned+= $planned;
					$totalMade+= $made;
				}
				$listUser.="</div>";
			}
		}

		$tabcontact = $object->liste_contact(-1, 'external');
		$listContact="";
		// la gestion des utilisateur
		$nbcontact = count($tabcontact);
		if ($nbUser > 0) {
			// champs contenant les ids des inter et contact ainsi que le temps associé
			foreach($tabcontact as $contactInter) {
				$ret = $contactstatic->fetch($contactInter['id']);
				$listContact.="<div  style='float:left;width:99%;'>";
				$listContact.="<div style='display: inline-block;'>".$contactstatic->getnomUrl(1)."</div>";
				$listContact.="</div>";
			}
		}


		$bshowelement=false;
		$textColor="black";
		// si pas de collaborateur
		if (count($tab) == 0){
			$bgcolor="#".$conf->global->MYSCHEDULE_colornouser;
			if(in_array('nouser', $statutinter))
				$bshowelement=true;
		} elseif ($totalPlanned < $objp->duree || $ret == 0) {
			$bgcolor="#".$conf->global->MYSCHEDULE_colornotplanned;
			if(in_array('notplanned', $statutinter))
				$bshowelement=true;
		} elseif($totalPlanned >= $objp->duree && $made == 0){
				$bgcolor="#".$conf->global->MYSCHEDULE_colornotmade;
			if(in_array('notmade', $statutinter))
				$bshowelement=true;
		} elseif($made > 0){
			$bgcolor="#".$conf->global->MYSCHEDULE_colormade;
			if(in_array('made', $statutinter))
				$bshowelement=true;
		} else {
			$bgcolor="#C0C0C0";
			if(in_array('made', $statutinter))
				$bshowelement=true;
		}

		if($bshowelement) {
			print '<tr><td valign=top>';
			print $object->getNomUrl(1);
			print '</td><td valign=top>';
			print $object->descinter;
			print '</td><td align=center>';
			$datedebevent =$db->jdate($objp->date_intervention);
			print date("d", $datedebevent)."/".date("m", $datedebevent)."/".date("Y", $datedebevent);
			print '</td><td align=right valign=top>';
			$dureehour = round($objp->duree/3600, 0, PHP_ROUND_HALF_DOWN);
			$dureemin =  ($objp->duree - ($dureehour*3600)) / 60;
			if ($dureemin < 10) 
				$dureemin = "0".$dureemin;
			print $dureehour.":".$dureemin;
			print '</td><td  valign=top>';
			print $object->description;
			print '</td>';
			print '<td valign=top >';
			if ($nbUser > $conf->global->MYSCHEDULE_nbcontactonlist)
				print img_picto($listUser, 'object_group', ' class="classfortooltip"' );
			else
				print $listUser;
			print '</td><td valign=top>';
			// on affiche la liste des contacts dans un tooltip si il sont trop nombreux
			if ($nbcontact> $conf->global->MYSCHEDULE_nbcontactonlist)
				print img_picto($listContact, 'object_group', ' class="classfortooltip"' );
			else
				print $listContact;
			print '</td><td style="background-color:'.$bgcolor.';" valign=top align=right>';
			print $object->getLibStatut(2);
			print '</td></tr>';
		}
		$j++;
	}
	print '</table >';

}


llxFooter();
$db->close();